#include "Uefi.h"
#include "Uefilib.h"
#include "MemoryAllocationLib.h" //For AllocateZeroPool
#include "Base.h" //For OFFSET_OF Macro
#include "BaseMemoryLib.h"
#include "TPM20Info.h"

#include "Tpm20_Types.h"
//#include "Tpm20.h"
#include "TpmTIS.h"
//#include "TPMInfo.h"
#include "WaitAndStatusCheck.h"
#include "OutputFormat.h"
#include "Debug.h"
#include "TPM2ErrorDecode.h"
//#include "stdio.h"

extern EFI_SYSTEM_TABLE   *gST;


/*********************************File Read Functions*****************************************************/

BOOLEAN read_FILEHEADER(EFI_FILE_HANDLE	*FileHandle, FILE_HEADER *fileHeader) 
{	
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	T2T_ARCHLIMITS 	archLimits;
	EFI_FILE_HANDLE	*FileHandleBackup;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print( L"readLine status: %x, ASCII: %x \n", Status, ascii);
	if (Status != EFI_DEVICE_ERROR || Status != EFI_INVALID_PARAMETER ) {
		FileHandleBackup = FileHandle;
		//Print( L"readBuffer: %s \n", readBuffer );	
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		//ZeroMem(fileHeader->fileSig, 20);
		if ( token != NULL && (StrLen(token) < 10) ) {
			CopyMem(fileHeader->fileSig, token, StrLen(token) * 2); 
			fileHeader->fileSig[StrLen(token)] = CHAR_NULL;
		} else {
			CopyMem(fileHeader->fileSig, token, 18);
			fileHeader->fileSig[9] = CHAR_NULL;
		}
		//Print( L"fileHeader->fileSig: %s \n", fileHeader->fileSig );	
	} else {
		Print(L"Error reading file\n");
		return FALSE;
	}

	//ascii = FALSE;
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print( L"readLine status: %x, ASCII: %x \n", Status, ascii);
	if (Status != EFI_DEVICE_ERROR || Status != EFI_INVALID_PARAMETER ) {
		//Print( L"readBuffer: %s \n", readBuffer );
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
		fileHeader->Tool_ID = (UINT8) u64offset;	
		//Print(L"Tool_ID: %d \n", fileHeader->Tool_ID );	
	} else {
		Print(L"Error reading file\n");
		return FALSE;
	}
		
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print( L"readLine status: %x, ASCII: %x \n", Status, ascii);
	if (Status != EFI_DEVICE_ERROR || Status != EFI_INVALID_PARAMETER ) {
		//Print( L"readBuffer: %s \n", readBuffer );
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
		fileHeader->ToolVersion = (UINT8) u64offset;	
		//Print(L"ToolVersion: %d \n", fileHeader->ToolVersion );	
	} else {
		Print(L"Error reading file\n");
		return FALSE;
	}
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	if (Status != EFI_DEVICE_ERROR || Status != EFI_INVALID_PARAMETER ) {
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
		fileHeader->toolLevel = (UINT8) u64offset;	
		//Print(L"toolLevel: %d \n", fileHeader->toolLevel );	
	} else {
		Print(L"Error reading file\n");
		return FALSE;
	}
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	if (Status != EFI_DEVICE_ERROR || Status != EFI_INVALID_PARAMETER ) {
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
		fileHeader->tpmFamily = (UINT8) u64offset;	
		//Print(L"tpmFamily: 0x%x \n", fileHeader->tpmFamily );	
	} else {
		Print(L"Error reading file\n");
		return FALSE;
	}
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	fileHeader->fileType = (UINT8) u64offset;	
	//Print(L"fileType: 0x%x \n", fileHeader->fileType );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	fileHeader->reserved0 = (UINT8) u64offset;	
	//Print(L"reserved0: 0x%x \n", fileHeader->reserved0 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fileHeader->StructVer = (UINT8) u64offset;	
	//Print(L"StructVer: 0x%x \n", fileHeader->StructVer );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fileHeader->StructFlags = (UINT8) u64offset;	
	//Print(L"StructFlags: 0x%x \n", fileHeader->StructFlags );	
	
	//read the T2T_ARCHLIMITS structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2T_ARCHLIMITS" ) == 0 ) {
		if (read_T2T_ARCHLIMITS(FileHandle, &archLimits) ) {
			CopyMem( &fileHeader->designLimits, &archLimits, sizeof(T2T_ARCHLIMITS) );
			//Print(L"fileHeader->designLimits.maxDigestSize: 0x%d\n", fileHeader->designLimits.maxDigestSize );
		}
	}
	
	return TRUE;
}

BOOLEAN read_T2T_ARCHLIMITS(EFI_FILE_HANDLE	*FileHandle, T2T_ARCHLIMITS *archLimits) 
{	
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	archLimits->maxDigestSize = (UINT8) u64offset;	
	//Print(L"maxDigestSize: %d \n", archLimits->maxDigestSize );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	archLimits->maxNumPcrs = (UINT8) u64offset;	
	//Print(L"maxNumPcrs: %d \n", archLimits->maxNumPcrs );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->maxSoS = (UINT8) u64offset;	
	//Print(L"maxSoS: 0x%x \n", archLimits->maxSoS );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->maxNumPcrAlg = (UINT8) u64offset;	
	//Print(L"maxNumPcrAlg: 0x%x \n", archLimits->maxNumPcrAlg );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->maxNumBanks = (UINT8) u64offset;	
	//Print(L"maxNumBanks: 0x%x \n", archLimits->maxNumBanks );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->reserved1 = (UINT8) u64offset;	
	//Print(L"reserved1: 0x%x \n", archLimits->reserved1 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->reserved2 = (UINT8) u64offset;	
	//Print(L"reserved2: 0x%x \n", archLimits->reserved2 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->reserved3 = (UINT8) u64offset;	
	//Print(L"reserved3: 0x%x \n", archLimits->reserved3 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->maxKeySize = (UINT16) u64offset;	
	//Print(L"maxKeySize: 0x%x \n", archLimits->maxKeySize );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	archLimits->maxDataBufSize = (UINT16) u64offset;	
	//Print(L"maxDataBufSize: 0x%x \n", archLimits->maxDataBufSize );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	archLimits->maxNumCmdCodes = (UINT16) u64offset;	
	//Print(L"maxNumCmdCodes: 0x%x \n", archLimits->maxNumCmdCodes );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->reserved4 = (UINT16) u64offset;	
	//Print(L"reserved4: 0x%x \n", archLimits->reserved4 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->reserved5 = (UINT16) u64offset;	
	//Print(L"reserved5: 0x%x \n", archLimits->reserved5 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->reserved6 = (UINT16) u64offset;	
	//Print(L"reserved6: 0x%x \n", archLimits->reserved6 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	archLimits->reserved7 = (UINT32) u64offset;	
	//Print(L"reserved7: 0x%x \n", archLimits->reserved7 );	
	
	return TRUE;
	
}

BOOLEAN read_T2T_SESSION_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_SESSION_DEF_FILE *sDef) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	FSR2B_KEY 		fsr2bKey;
	FSR2B_AUTH 		fsr2bAuth;
	TPMT_SYM_DEF 	symDef;
	UINT8			sessionAttribute;

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->tpmKey = (UINT32) u64offset;	
	//Print(L"sDef->tpmKey: 0x%x \n", sDef->tpmKey );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->bind = (UINT32) u64offset;	
	//Print(L"sDef->bind: 0x%x \n", sDef->bind );	
	

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	sDef->nonceSize = (UINT16) u64offset;	
	//Print(L"sDef->nonceSize: %d \n", sDef->nonceSize );	
	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->nonceType = (UINT8) u64offset;	
	//Print(L"sDef->nonceType: 0x%x \n", sDef->nonceType );	
	
	
	//read the FSR2B_Key structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_KEY" ) == 0 ) {
		if( read_FSR2B_KEY(FileHandle, &fsr2bKey ) ) {
			CopyMem( &sDef->encryptedSalt, &fsr2bKey, sizeof(FSR2B_KEY) );
			//Print(L"sDef->encryptedSalt.Size: 0x%d\n", sDef->encryptedSalt.Size );
		}
	}
	
	//SDEF_CONT tag
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->sessionType = (UINT8) u64offset;	
	//Print(L"sDef->sessionType: 0x%x \n", sDef->sessionType );
	
	
	//read the TPMT_SYM_DEF structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//TPMT_SYM_DEF" ) == 0 ) {
		if( read_TPMT_SYM_DEF(FileHandle, &symDef ) ) {
			CopyMem( &sDef->symmetric, &symDef, sizeof(TPMT_SYM_DEF) );
			//Print(L"sDef->symmetric.algorithm: 0x%x\n", sDef->symmetric.algorithm );
		}
	}
	

	//SDEF
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->authHashAlg = (UINT16) u64offset;	
	//Print(L"sDef->authHashAlg: 0x%x \n", sDef->authHashAlg );	
	
	//UINT8 bit field breakdown. Mask each field to find the value of the bit in the bit field TODO mask
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"readBuffer: %s\n", readBuffer );
	token = mystrtok(readBuffer, &delim);
	//Print(L"token: %s\n", token );
	token = mystrtok(NULL, &delim);
	//Print(L"token: %s\n", token );
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	//Print(L"u64offset: 0x%x\n", u64offset );
	sessionAttribute = (UINT8) u64offset;
	CopyMem( &sDef->sessionAttr, &sessionAttribute, 1);
	/*
	Print(L"sDef->sessionAttr.continueSession: 0x%x \n", sDef->sessionAttr.continueSession );	
	Print(L"sDef->sessionAttr.auditExclusive: 0x%x \n", sDef->sessionAttr.auditExclusive );	
	Print(L"sDef->sessionAttr.auditReset: 0x%x \n", sDef->sessionAttr.auditReset );	
	Print(L"sDef->sessionAttr.reserved4: 0x%x \n", sDef->sessionAttr.reserved4 );	
	Print(L"sDef->sessionAttr.encrypted: 0x%x \n", sDef->sessionAttr.encrypted );	
	Print(L"sDef->sessionAttr.encrypt: 0x%x \n", sDef->sessionAttr.encrypt );	
	Print(L"sDef->sessionAttr.audit: 0x%x \n", sDef->sessionAttr.audit );	
	*/
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->authSource = (UINT8) u64offset;	
	//Print(L"sDef->authSource: 0x%x \n", sDef->authSource );	
	
	//read the FSR2B_DIGEST structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &fsr2bAuth ) ) {
			CopyMem( &sDef->authValue, &fsr2bAuth, sizeof(FSR2B_AUTH) );
			//Print(L"sDef->authValue.size: 0x%d\n", sDef->authValue.size );
		}
	}
	
	//salted session
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	sDef->saltEncMode = (UINT16) u64offset;	
	//Print(L"sDef->saltEncMode: %d \n", sDef->saltEncMode );	

	//read the salt
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &fsr2bAuth ) ) {
			CopyMem( &sDef->salt, &fsr2bAuth, sizeof(FSR2B_AUTH) );
			//Print(L"sDef->authValue.size: 0x%d\n", sDef->authValue.size );
		}
	}

	//read the salt key
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_KEY" ) == 0 ) {
		if( read_FSR2B_KEY(FileHandle, &fsr2bKey ) ) {
			CopyMem( &sDef->saltKey, &fsr2bKey, sizeof(FSR2B_KEY) );
			//Print(L"sDef->encryptedSalt.Size: 0x%d\n", sDef->encryptedSalt.Size );
		}
	}

	//read the bind value
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &fsr2bAuth ) ) {
			CopyMem( &sDef->bindValue, &fsr2bAuth, sizeof(FSR2B_AUTH) );
			//Print(L"sDef->authValue.size: 0x%d\n", sDef->authValue.size );
		}
	}


	//SDEF_CONT tag
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->reserved = (UINT32) u64offset;	
	//Print(L"sDef->reserved: 0x%x \n", sDef->reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->reserved1 = (UINT32) u64offset;	
	//Print(L"sDef->reserved1: 0x%x \n", sDef->reserved1 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sDef->reserved2 = (UINT32) u64offset;	
	//Print(L"sDef->reserved2: 0x%x \n", sDef->reserved2 );	
	
	return TRUE;
}

BOOLEAN read_FSR2B_KEY(EFI_FILE_HANDLE *FileHandle, FSR2B_KEY *fsr2bKey) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[512];
	CHAR16			responseBuffer[256] = L"";
	CHAR16			delim[25] = L":";
	UINTN 			size = 512;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	UINT32			i = 0;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bKey->size = (UINT16) u64offset;	
	//Print(L"fsr2bKey->Size: 0x%x \n", fsr2bKey->size );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bKey->buffer.bufType = (UINT8) u64offset;	
	//Print(L"fsr2bKey->buffer.bufType: 0x%x \n", fsr2bKey->buffer.bufType );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bKey->buffer.fileType = (UINT8) u64offset;	
	//Print(L"fsr2bKey->buffer.fileType: 0x%x \n", fsr2bKey->buffer.fileType );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bKey->buffer.dataIndex = (UINT16) u64offset;	
	//Print(L"fsr2bKey->buffer.dataIndex: 0x%x \n", fsr2bKey->buffer.dataIndex );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bKey->buffer.reserved = (UINT32) u64offset;	
	//Print(L"fsr2bKey->buffer.reserved: 0x%x \n", fsr2bKey->buffer.reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	fsr2bKey->buffer.maxSize = (UINT16) u64offset;	
	//Print(L"fsr2bKey->buffer.maxSize: %d \n", fsr2bKey->buffer.maxSize );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bKey->buffer.size = (UINT16) u64offset;	
	//Print(L"fsr2bKey->buffer.size: 0x%x \n", fsr2bKey->buffer.size );	
	
	pnvDataBuffer = &fsr2bKey->buffer.buffer;
	ZeroMem ( pnvDataBuffer, T2T_MAX_KEY );
	if ( fsr2bKey->buffer.size > 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		CopyMem(responseBuffer, token, StrLen(token) * 2);
				
		for ( i = 1; i < StrLen(token); i+=2 ) {				

			responseByte[0] = responseBuffer[i];
			responseByte[1] = responseBuffer[i + 1];
			responseByte[2] = CHAR_NULL;
			
			Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
						
			CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
			pnvDataBuffer++;
			u64offset = 0;
			ZeroMem(responseByte, 4);			
		}
		/*
		Print(L"Buffer: ");
		for (i = 0; i < fsr2bKey->buffer.size; i++ ) {
			Print(L"%02x ",  fsr2bKey->buffer.buffer[i] );
		}
		Print(L"\n");
		*/
	} else {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Buffer: \n");
	}
	
	return TRUE;
}

BOOLEAN read_TPMT_SYM_DEF(EFI_FILE_HANDLE *FileHandle, TPMT_SYM_DEF *symDef) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			responseBuffer[256] = L"";
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	UINT32			i = 0;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	symDef->algorithm = (UINT16) u64offset;	
	//Print(L"symDef->algorithm: 0x%x \n", symDef->algorithm );	

	//copy mem because the compiler complains and we know the keybits is a UINT16
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	//symDef->keyBits = (UINT16) u64offset;	
	CopyMem( &symDef->keyBits, &u64offset, sizeof(UINT16) );
	//Print(L"symDef->details.param.keyBits: 0x%x \n", symDef->keyBits );	

	//copy mem because the compiler complains and we know the mode is a UINT16
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	//symDef->mode = (UINT16) u64offset;	
	CopyMem( &symDef->mode, &u64offset, sizeof(UINT16) );
	//Print(L"symDef->details.param.mode: 0x%x \n", symDef->mode );	
		
	
}

BOOLEAN read_FSR2B_AUTH(EFI_FILE_HANDLE *FileHandle, FSR2B_AUTH *fsr2bAuth) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[512];
	CHAR16			responseBuffer[256] = L"";
	CHAR16			delim[25] = L":";
	UINTN 			size = 512;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	UINT32			i = 0;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bAuth->size = (UINT16) u64offset;	
	//Print(L"fsr2bAuth->size: 0x%x \n", fsr2bAuth->size );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bAuth->buffer.bufType = (UINT8) u64offset;	
	//Print(L"fsr2bAuth->buffer.bufType: 0x%x \n", fsr2bAuth->buffer.bufType );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bAuth->buffer.fileType = (UINT8) u64offset;	
	//Print(L"fsr2bAuth->buffer.fileType: 0x%x \n", fsr2bAuth->buffer.fileType );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bAuth->buffer.dataIndex = (UINT16) u64offset;	
	//Print(L"fsr2bAuth->buffer.dataIndex: 0x%x \n", fsr2bAuth->buffer.dataIndex );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bAuth->buffer.reserved = (UINT32) u64offset;	
	//Print(L"fsr2bAuth->buffer.reserved: 0x%x \n", fsr2bAuth->buffer.reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	fsr2bAuth->buffer.maxSize = (UINT16) u64offset;	
	//Print(L"fsr2bAuth->buffer.maxSize: %d \n", fsr2bAuth->buffer.maxSize );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bAuth->buffer.size = (UINT16) u64offset;	
	//Print(L"fsr2bAuth->buffer.size: 0x%x \n", fsr2bAuth->buffer.size );	
	
	pnvDataBuffer = &fsr2bAuth->buffer.buffer;
	ZeroMem ( pnvDataBuffer, T2T_MAX_DIGEST );
	if ( fsr2bAuth->buffer.size > 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		CopyMem(responseBuffer, token, StrLen(token) * 2);
				
		for ( i = 1; i < StrLen(token); i+=2 ) {				

			responseByte[0] = responseBuffer[i];
			responseByte[1] = responseBuffer[i + 1];
			responseByte[2] = CHAR_NULL;
			
			Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
						
			CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
			pnvDataBuffer++;
			u64offset = 0;
			ZeroMem(responseByte, 4);			
		}
		/*
		Print(L"Buffer: ");
		for (i = 0; i < fsr2bAuth->buffer.size; i++ ) {
			Print(L"%02x ",  fsr2bAuth->buffer.buffer[i] );
		}
		Print(L"\n");
		*/
	} else {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Buffer: \n");
	}

	return TRUE;
}

BOOLEAN read_T2T_NV_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_NV_DEF_FILE *iDef) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	FSR2B_KEY 		fsr2bKey;
	FSR2B_AUTH 		fsr2bAuth;
	//TPMT_SYM_DEF 	symDef;
	FSR2B_NV_PUBLIC  fsrsNvPublic;
	FSR2B_DATABUF 	fsr2bDataBuffer;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	iDef->hierarchy = (UINT32) u64offset;	
	//Print(L"iDef->hierarchy: 0x%x \n", iDef->hierarchy );	
	
	//read the FSR2B_AUTH structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &fsr2bAuth ) ) {
			CopyMem( &iDef->auth, &fsr2bAuth, sizeof(FSR2B_AUTH) );
			//Print(L"iDef->auth.size: 0x%d\n", iDef->auth.size );
		}
	}
	
	//read the FSR2B_NV_PUBLIC structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_NV_PUBLIC" ) == 0 ) {
		if( read_FSR2B_NV_PUBLIC(FileHandle, &fsrsNvPublic ) ) {
			CopyMem( &iDef->publicInfo, &fsrsNvPublic, sizeof(FSR2B_NV_PUBLIC) );
			//Print(L"iDef->publicInfo.nvIndex: 0x%x\n", iDef->publicInfo.nvIndex );
		}
	}
	
	//IDEF_CONT
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	iDef->verify = (UINT32) u64offset;	
	//Print(L"iDef->verify: 0x%x \n", iDef->verify );	
	

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	iDef->attibuteMask = (UINT32) u64offset;	
	//Print(L"iDef->attibuteMask: 0x%x \n", iDef->attibuteMask );	
	
	
	//read the FSR2B_DATABUF structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_DATABUF" ) == 0 ) {
		if( read_FSR2B_DATABUF(FileHandle, &fsr2bDataBuffer ) ) {
			CopyMem( &iDef->dataSource, &fsr2bDataBuffer, sizeof(FSR2B_DATABUF) );
			//Print(L"iDef->dataSource.size: 0x%x\n", iDef->dataSource.size );
		}
	}
	
	
	//IDEF_CONT tag
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	iDef->offset = (UINT8) u64offset;	
	//Print(L"iDef->offset: 0x%x \n", iDef->offset );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	iDef->reserved = (UINT32) u64offset;	
	//Print(L"iDef->reserved: 0x%x \n", iDef->reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	iDef->reserved1 = (UINT32) u64offset;	
	//Print(L"iDef->reserved1: 0x%x \n", iDef->reserved1 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	iDef->reserved2 = (UINT32) u64offset;	
	//Print(L"iDef->reserved2: 0x%x \n", iDef->reserved2 );	
	
	return TRUE;
}

BOOLEAN read_FSR2B_DATABUF(EFI_FILE_HANDLE *FileHandle, FSR2B_DATABUF *fsr2bDataBuffer) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[2048];
	CHAR16			responseBuffer[2048] = L"";
	CHAR16			delim[25] = L":";
	UINTN 			size = 2048;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	VDR_DATABUF		vdrDataBuffer;
	UINT32			i = 0;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bDataBuffer->size = (UINT16) u64offset;	
	//Print(L"fsr2bDataBuffer->size: 0x%x \n", fsr2bDataBuffer->size );	
	
	//read the VDR_DATABUF structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bDataBuffer->buffer.bufType = (UINT8) u64offset;	
	//Print(L"fsr2bDataBuffer->buffer.bufType: 0x%x \n", fsr2bDataBuffer->buffer.bufType );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bDataBuffer->buffer.fileType = (UINT8) u64offset;	
	//Print(L"fsr2bDataBuffer->buffer.fileType: 0x%x \n", fsr2bDataBuffer->buffer.fileType );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bDataBuffer->buffer.dataIndex = (UINT16) u64offset;	
	//Print(L"fsr2bDataBuffer->buffer.dataIndex: 0x%x \n", fsr2bDataBuffer->buffer.dataIndex );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bDataBuffer->buffer.reserved = (UINT32) u64offset;	
	//Print(L"fsr2bDataBuffer->buffer.reserved: 0x%x \n", fsr2bDataBuffer->buffer.reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	fsr2bDataBuffer->buffer.maxSize = (UINT16) u64offset;	
	//Print(L"fsr2bDataBuffer->buffer.maxSize: %d \n", fsr2bDataBuffer->buffer.maxSize );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bDataBuffer->buffer.size = (UINT16) u64offset;	
	//Print(L"fsr2bDataBuffer->buffer.size: 0x%x \n", fsr2bDataBuffer->buffer.size );	
	
	pnvDataBuffer = &fsr2bDataBuffer->buffer.buffer;
	ZeroMem ( pnvDataBuffer, T2T_MAX_DATABUF );
	if ( fsr2bDataBuffer->buffer.size > 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		CopyMem(responseBuffer, token, StrLen(token) * 2);

		Print(L"StrLen(token): %d\n", StrLen(token));

		for ( i = 1; i < StrLen(token); i+=2 ) {				

			responseByte[0] = responseBuffer[i];
			responseByte[1] = responseBuffer[i + 1];
			responseByte[2] = CHAR_NULL;
			
			Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
			Print(L"byte: 0x%x\n", u64offset);
			CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
			pnvDataBuffer++;
			u64offset = 0;
			ZeroMem(responseByte, 4);			
		}
		
		Print(L"Buffer: ");
		for (i = 0; i < fsr2bDataBuffer->buffer.size; i++ ) {
			Print(L"%02x ",  fsr2bDataBuffer->buffer.buffer[i] );
		}
		Print(L"\n");
		
	} else {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Buffer: ");
	}
	
	return TRUE;
}

BOOLEAN read_FSR2B_NV_PUBLIC(EFI_FILE_HANDLE *FileHandle, FSR2B_NV_PUBLIC *fsr2bNvPublic) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[512];
	CHAR16			responseBuffer[256] = L"";
	CHAR16			delim[25] = L":";
	UINTN 			size = 512;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	FSR2B_DIGEST	fsr2bDigest;
	UINT32			i = 0;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bNvPublic->size = (UINT16) u64offset;	
	//Print(L"fsr2bNvPublic->size: 0x%x \n", fsr2bNvPublic->size );	
	
	//FSRS_NV_PUBLIC
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bNvPublic->nvPublic.nvIndex = (UINT32) u64offset;	
	//Print(L"fsr2bNvPublic->nvPublic.nvIndex: 0x%x \n", fsr2bNvPublic->nvPublic.nvIndex );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	fsr2bNvPublic->nvPublic.nameAlg = (UINT16) u64offset;	
	//Print(L"fsr2bNvPublic->nvPublic.nameAlg: 0x%x \n", fsr2bNvPublic->nvPublic.nameAlg );	
	
	
	//UINT32 bit field breakdown. Mask each field to find the value of the bit in the bit field TODO mask
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	CopyMem( &fsr2bNvPublic->nvPublic.attributes, &u64offset, sizeof(UINT32) );
	
	
	
	//read the read_FSR2B_DIGEST structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &fsr2bDigest ) ) {
			CopyMem( &fsr2bNvPublic->nvPublic.authPolicy, &fsr2bDigest, sizeof(FSR2B_DIGEST) );
			//Print(L"fsr2bNvPublic->nvPublic.authPolicy.size: 0x%x\n", fsr2bNvPublic->nvPublic.authPolicy.size );
		}
	}
	
	//FSRS_NV_PUBLIC_CONT
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	fsr2bNvPublic->nvPublic.dataSize = (UINT16) u64offset;	
	//Print(L"fsr2bNvPublic->nvPublic.dataSize: 0x%x \n", fsr2bNvPublic->nvPublic.dataSize );	
	
	return TRUE;
}

BOOLEAN read_T2P_AUTH(EFI_FILE_HANDLE *FileHandle, T2P_AUTH *pTp2Auth) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[512];
	CHAR16			delim[25] = L":";
	UINTN 			size = 512;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;
	UINT32			index = 0;

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pTp2Auth->size = (UINT16) u64offset;	
	//Print(L"pTp2Auth->size: 0x%x \n", pTp2Auth->size );	
	
	//read buffer
	pnvDataBuffer = &pTp2Auth->buffer;
	ZeroMem ( pnvDataBuffer, T2T_MAX_DIGEST );
	if ( pTp2Auth->size > 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		CopyMem(responseBuffer, token, StrLen(token) * 2);
				
		for ( i = 1; i < StrLen(token); i+=2 ) {				

			responseByte[0] = responseBuffer[i];
			responseByte[1] = responseBuffer[i + 1];
			responseByte[2] = CHAR_NULL;
			
			Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
			
			pTp2Auth->buffer[index] = (UINT8 )u64offset;
			index++;

			//CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
			//pnvDataBuffer++;
			u64offset = 0;
			ZeroMem(responseByte, 4);			
		}
		/*
		Print(L"Buffer: ");
		for (i = 0; i < pTp2Auth->size; i++ ) {
			Print(L"%02x ",  pTp2Auth->buffer[i] );
		}
		Print(L"\n");
		*/
	} else {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Buffer: \n");
	}

	return TRUE;
}

BOOLEAN read_T2P_DATA(EFI_FILE_HANDLE *FileHandle, T2P_DATA *pTp2Data) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[T2T_MAX_DATA * 2];
	CHAR16			delim[25] = L":";
	UINTN 			size = T2T_MAX_DATA * 2;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[T2T_MAX_DATA * 2] = L"";
	UINT32			i = 0;
	UINT32			index = 0;

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pTp2Data->size = (UINT16) u64offset;	
	//Print(L"pTp2Data->size: 0x%x \n", pTp2Data->size );	
	
	//read buffer
	pnvDataBuffer = &pTp2Data->buffer;
	ZeroMem ( pnvDataBuffer, T2T_MAX_DATA );
	if ( pTp2Data->size > 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Read Buffer: ");
		//for (i = 0; i < (pTp2Data->size * 2) + 9; i++ ) {
		//	Print(L"%c ",  readBuffer[i] );
		//}
		//Print(L"\n");
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		CopyMem(responseBuffer, token, StrLen(token) * 2);
		//Print(L"string length token: %d\n", StrLen(token) );
		for ( i = 1; i < StrLen(token); i+=2 ) {				

			responseByte[0] = responseBuffer[i];
			responseByte[1] = responseBuffer[i + 1];
			responseByte[2] = CHAR_NULL;
			
			Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );

			//memcpy(&pTp2Data->buffer[index], &test, 1);
			//CopyMem(&pTp2Data->buffer[index], (UINT8 *)&u64offset, 1);
			pTp2Data->buffer[index] = (UINT8 )u64offset;
			index++;
			//CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
			//pnvDataBuffer++;
			u64offset = 0;
			ZeroMem(responseByte, 4);			
		}
		/*
		Print(L"Buffer: ");
		for (i = 0; i < pTp2Data->size; i++ ) {
			Print(L"%02x ",  pTp2Data->buffer[i] );
		}
		Print(L"\n");
		*/
	} else {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Buffer: \n");
	}

	return TRUE;
}

BOOLEAN read_T2P_SESSION_CONTEX(EFI_FILE_HANDLE *FileHandle, T2P_SESSION_CONTEX *sessionContext) 
{

	
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	FSR2B_KEY 		fsr2bKey;
	FSR2B_AUTH 		fsr2bAuth;
	TPMT_SYM_DEF 	symDef;
	
	CHAR16			responseBuffer[256] = L"";
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	UINT32			i = 0;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->sessionHandle = (UINT32) u64offset;	
	//Print(L"sessionContext->sessionHandle: 0x%x \n", sessionContext->sessionHandle );	
	
	//read the T2P_TPM2B_100 structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->lastNonceTpm.size = (UINT16) u64offset;	
	//Print(L"sessionContext->lastNonceTpm.size: 0x%x \n", sessionContext->lastNonceTpm.size );	
	
	pnvDataBuffer = &sessionContext->lastNonceTpm.buffer;
	ZeroMem ( pnvDataBuffer, T2T_MAX_DIGEST );
	if ( sessionContext->lastNonceTpm.size > 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		CopyMem(responseBuffer, token, StrLen(token) * 2);
				
		for ( i = 1; i < StrLen(token); i+=2 ) {				

			responseByte[0] = responseBuffer[i];
			responseByte[1] = responseBuffer[i + 1];
			responseByte[2] = CHAR_NULL;
			
			Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
						
			CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
			pnvDataBuffer++;
			u64offset = 0;
			ZeroMem(responseByte, 4);			
		}
		/*
		Print(L"Buffer: ");
		for (i = 0; i < sessionContext->lastNonceTpm.size; i++ ) {
			Print(L"%02x ",  sessionContext->lastNonceTpm.buffer[i] );
		}
		Print(L"\n");
		*/
	} else {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Buffer: \n");
	}
	
	//read the SDEF structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->tpmKey = (UINT32) u64offset;	
	//Print(L"sessionContext->tpmKey: 0x%x \n", sessionContext->tpmKey );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->bind = (UINT32) u64offset;	
	//Print(L"sessionContext->bind: 0x%x \n", sessionContext->bind );	
	

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE );	
	sessionContext->nonceSize = (UINT16) u64offset;	
	//Print(L"sessionContext->nonceSize: %d \n", sessionContext->nonceSize );	
	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->nonceType = (UINT8) u64offset;	
	//Print(L"sessionContext->nonceType: 0x%x \n", sessionContext->nonceType );	
	
	
	//read the FSR2B_Key structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_KEY" ) == 0 ) {
		if( read_FSR2B_KEY(FileHandle, &fsr2bKey ) ) {
			CopyMem( &sessionContext->encryptedSalt, &fsr2bKey, sizeof(FSR2B_KEY) );
			//Print(L"sessionContext->encryptedSalt.Size: 0x%d\n", sessionContext->encryptedSalt.Size );
		}
	}
	
	//SDEF_CONT tag
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->sessionType = (UINT8) u64offset;	
	//Print(L"sessionContext->sessionType: 0x%x \n", sessionContext->sessionType );
	
	
	//read the TPMT_SYM_DEF structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//TPMT_SYM_DEF" ) == 0 ) {
		if( read_TPMT_SYM_DEF(FileHandle, &symDef ) ) {
			CopyMem( &sessionContext->symmetric, &symDef, sizeof(TPMT_SYM_DEF) );
			//Print(L"sessionContext->symmetric.algorithm: 0x%x\n", sessionContext->symmetric.algorithm );
		}
	}
	
	//SDEF
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->authHashAlg = (UINT16) u64offset;	
	//Print(L"sessionContext->authHashAlg: 0x%x \n", sessionContext->authHashAlg );	
	
	//UINT8 bit field breakdown. Mask each field to find the value of the bit in the bit field TODO mask
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	sessionContext->sessionAttr.continueSession = (UINT8)(0x1 & (UINT8) u64offset);	
	sessionContext->sessionAttr.auditExclusive = (UINT8)(0x2 & (UINT8) u64offset);		
	sessionContext->sessionAttr.auditReset = (UINT8)(0x4 & (UINT8) u64offset);	
	sessionContext->sessionAttr.reserved3_4 = (UINT8)(0x18 & (UINT8) u64offset);	
	sessionContext->sessionAttr.decrypt = (UINT8)(0x20 & (UINT8) u64offset);	
	sessionContext->sessionAttr.encrypt = (UINT8)(0x40 & (UINT8) u64offset);	
	sessionContext->sessionAttr.audit = (UINT8)(0x80 & (UINT8) u64offset);	
	/*
	Print(L"sessionContext->sessionAttr.continueSession: 0x%x \n", sessionContext->sessionAttr.continueSession );	
	Print(L"sessionContext->sessionAttr.auditExclusive: 0x%x \n", sessionContext->sessionAttr.auditExclusive );
	Print(L"sessionContext->sessionAttr.auditReset: 0x%x \n", sessionContext->sessionAttr.auditReset );
	Print(L"sessionContext->sessionAttr.reserved3_4: 0x%x \n", sessionContext->sessionAttr.reserved3_4 );
	Print(L"sessionContext->sessionAttr.encrypted: 0x%x \n", sessionContext->sessionAttr.decrypt );
	Print(L"sessionContext->sessionAttr.encrypt: 0x%x \n", sessionContext->sessionAttr.encrypt );
	Print(L"sessionContext->sessionAttr.audit: 0x%x \n", sessionContext->sessionAttr.audit );
	*/

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->authSource = (UINT8) u64offset;	
	//Print(L"sessionContext->authSource: 0x%x \n", sessionContext->authSource );	
	
	//read the FSR2B_DIGEST structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &fsr2bAuth ) ) {
			CopyMem( &sessionContext->authValue, &fsr2bAuth, sizeof(FSR2B_AUTH) );
			//Print(L"sessionContext->authValue.size: 0x%d\n", sessionContext->authValue.size );
		}
	}
	
	//SDEF_CONT tag
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->reserved = (UINT32) u64offset;	
	//Print(L"sessionContext->reserved: 0x%x \n", sessionContext->reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->reserved1 = (UINT32) u64offset;	
	//Print(L"sessionContext->reserved1: 0x%x \n", sessionContext->reserved1 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sessionContext->reserved2 = (UINT32) u64offset;	
	//Print(L"sessionContext->reserved2: 0x%x \n", sessionContext->reserved2 );	
	
	return TRUE;
}

BOOLEAN read_T2P_SEQUENCE_CONTEXT(EFI_FILE_HANDLE *FileHandle, T2P_SEQUENCE_CONTEXT *pSequContext) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	T2P_AUTH 		authValue;

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pSequContext->seqHandle = (UINT32) u64offset;	
	//Print(L"pSequContext->seqHandle: 0x%x \n", pSequContext->seqHandle );	

	//read the T2P_AUTH structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_AUTH" ) == 0 ) {
		if( read_T2P_AUTH( FileHandle, &authValue ) ) {
				CopyMem( &pSequContext->authValue, &authValue, sizeof(T2P_AUTH) );
				//Print(L"pSequContext->authValue[].size: 0x%d\n", pSequContext->authValue.size );
		}	
	}
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pSequContext->reserved = (UINT32) u64offset;	
	//Print(L"pSequContext->reserved: 0x%x \n", pSequContext->reserved );	
	
	return TRUE;
}

BOOLEAN read_T2P_CONFIG_FILE(EFI_FILE_HANDLE *FileHandle, T2P_CONFIG_FILE *sCfg) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	FSR2B_KEY 		fsr2bKey;
	FSR2B_AUTH 		platformAuth;
	FSR2B_AUTH 		ownerAuth;
	T2P_AUTH 		authValue;
	T2P_DATA		dataValue;
	T2P_SESSION_CONTEX sessionContext;
	T2P_SEQUENCE_CONTEXT pSequContext;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;

	
	//read the FSR2B_AUTH structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &platformAuth ) ) {
			CopyMem( &sCfg->platformAuth, &platformAuth, sizeof(FSR2B_AUTH) );
			//Print(L"sCfg->platformAuth.size: 0x%d\n", sCfg->platformAuth.size );
		}
	}
	
	//read the FSR2B_AUTH structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &ownerAuth ) ) {
			CopyMem( &sCfg->ownerAuth, &ownerAuth, sizeof(FSR2B_AUTH) );
			//Print(L"sCfg->ownerAuth.size: 0x%d\n", sCfg->ownerAuth.size );
		}
	}
	
	//read the T2P_AUTH 5 structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_AUTH 5" ) == 0 ) {
		for (i = 0; i < 5; i++ ) {
			ZeroMem(&authValue, sizeof(T2P_AUTH));
			if( read_T2P_AUTH( FileHandle, &authValue ) ) {
					CopyMem( &sCfg->authValue[i], &authValue, sizeof(T2P_AUTH) );
					//Print(L"sCfg->authValue[].size: 0x%d\n", sCfg->authValue[i].size );
			}
		}
	}
	
	//TPM_HANDLE 10
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	for ( i = 0; i < 10; i++ ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		//Print(L"token: %s\n", token);
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		sCfg->objHandle[i] = (UINT32)u64offset;	
		//Print(L"sCfg->objHandle: 0x%x \n", sCfg->objHandle[i] );	
	}
	
	//read the T2P_AUTH 8 structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_AUTH 8" ) == 0 ) {
		for (i = 0; i < 8; i++ ) {
			ZeroMem(&authValue, sizeof(T2P_AUTH));
			if( read_T2P_AUTH( FileHandle, &authValue ) ) {
					CopyMem( &sCfg->digest[i], &authValue, sizeof(T2P_AUTH) );
					//Print(L"sCfg->digest[].size: 0x%d\n", sCfg->digest[i].size );
			}
		}
	}
	
	//read the //T2P_SESSION_CONTEX structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_SESSION_CONTEX" ) == 0 ) {
		if( read_T2P_SESSION_CONTEX(FileHandle, &sessionContext) ) {
			CopyMem( &sCfg->session[0], &sessionContext, sizeof(T2P_SESSION_CONTEX) );
			//Print(L"sCfg->ownerAuth.size: 0x%d\n", sCfg->ownerAuth.size );
		}
		
		for (i = 1; i < 5; i++ ) {
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			//Print(L"Structure: %s\n", readBuffer);	
			ZeroMem(&sessionContext, sizeof(T2P_SESSION_CONTEX));
			if( read_T2P_SESSION_CONTEX(FileHandle, &sessionContext) ) {
				CopyMem( &sCfg->session[i], &sessionContext, sizeof(T2P_SESSION_CONTEX) );
				//Print(L"sCfg->ownerAuth.size: 0x%d\n", sCfg->ownerAuth.size );
			}
		}
	}
	
	//read the FSR2B_Key structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_KEY" ) == 0 ) {
		if( read_FSR2B_KEY(FileHandle, &fsr2bKey ) ) {
			CopyMem( &sCfg->key[0], &fsr2bKey, sizeof(FSR2B_KEY) );
			//Print(L"sCfg->encryptedSalt.Size: 0x%d\n", sCfg->encryptedSalt.Size );
		}
		for (i = 1; i < 4; i++ ) {
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			//Print(L"Structure: %s\n", readBuffer);
			ZeroMem(&fsr2bKey, sizeof(FSR2B_KEY));
			if( read_FSR2B_KEY(FileHandle, &fsr2bKey ) ) {
				CopyMem( &sCfg->key[i], &fsr2bKey, sizeof(FSR2B_KEY) );
				//Print(L"sCfg->encryptedSalt.Size: 0x%d\n", sCfg->encryptedSalt.Size );
			}
		}
	}
	
	//read the T2P_SEQUENCE_CONTEXT structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_SEQUENCE_CONTEXT" ) == 0 ) {
		if( read_T2P_SEQUENCE_CONTEXT(FileHandle, &pSequContext ) ) {
			CopyMem( &sCfg->hmacSequence, &pSequContext, sizeof(T2P_SEQUENCE_CONTEXT) );
			//Print(L"sCfg->encryptedSalt.Size: 0x%d\n", sCfg->encryptedSalt.Size );
		}
	}
	
	ZeroMem(&pSequContext, sizeof(T2P_SEQUENCE_CONTEXT));
	
	//read the T2P_SEQUENCE_CONTEXT structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_SEQUENCE_CONTEXT" ) == 0 ) {
		if( read_T2P_SEQUENCE_CONTEXT(FileHandle, &pSequContext ) ) {
			CopyMem( &sCfg->hashSequence, &pSequContext, sizeof(T2P_SEQUENCE_CONTEXT) );
			//Print(L"sCfg->encryptedSalt.Size: 0x%d\n", sCfg->encryptedSalt.Size );
		}
	}
	
	//T2P_DATA                data[8];              //storage for 8 data elements
	for ( i = 0; i < 8; i++ ) {

		//read the T2P_AUTH structure from the file
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
		if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
			if( read_T2P_DATA( FileHandle, &dataValue ) ) {
				CopyMem( &sCfg->data[i], &dataValue, sizeof(T2P_DATA) );
				//Print(L" sCfg->data[%d].size: 0x%x\n", i,  sCfg->data[i].size );
			}	
		}
	}

	//SCFG_CONT tag
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sCfg->reserved = (UINT32) u64offset;	
	//Print(L"sCfg->reserved: 0x%x \n", sCfg->reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sCfg->reserved1 = (UINT32) u64offset;	
	//Print(L"sCfg->reserved1: 0x%x \n", sCfg->reserved1 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sCfg->reserved2 = (UINT32) u64offset;	
	//Print(L"sCfg->reserved2: 0x%x \n", sCfg->reserved2 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	sCfg->reserved3 = (UINT32) u64offset;	
	//Print(L"sCfg->reserved3: 0x%x \n", sCfg->reserved3 );	
	
	return TRUE;
}

BOOLEAN read_T2T_POLA_SIGNED(EFI_FILE_HANDLE *FileHandle, T2T_POLA_SIGNED *paramsSign) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;
	FSR2B_NONCE		nonceTPM;
	FSR2B_DIGEST	cpHashA;
	FSR2B_NONCE		policyRef;
	FSR2B_PUBLIC_KEY	signature;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsSign->authObject = (UINT32) u64offset;	
	//Print(L"paramsSign->authObject: 0x%x \n", paramsSign->authObject );
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_NONCE" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &nonceTPM) ) {
			CopyMem( &paramsSign->nonceTPM, &nonceTPM, sizeof(FSR2B_DIGEST) );
			//Print(L"paramsSign->encryptedSalt.Size: 0x%d\n", paramsSign->encryptedSalt.Size );
		}
	}
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &cpHashA) ) {
			CopyMem( &paramsSign->cpHashA, &cpHashA, sizeof(FSR2B_NONCE) );
			//Print(L"paramsSign->encryptedSalt.Size: 0x%d\n", paramsSign->encryptedSalt.Size );
		}
	}
	
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_NONCE" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &policyRef) ) {
			CopyMem( &paramsSign->policyRef, &policyRef, sizeof(FSR2B_NONCE) );
			//Print(L"paramsSign->encryptedSalt.Size: 0x%d\n", paramsSign->encryptedSalt.Size );
		}
	}
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsSign->expiration = (UINT32) u64offset;	
	//Print(L"paramsSign->expiration: 0x%x \n", paramsSign->expiration );
	
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSRT_SIGNATURE" ) == 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		paramsSign->auth.sigAlg = (UINT16) u64offset;	
		//Print(L"paramsSign->auth.sigAlg: 0x%x \n", paramsSign->auth.sigAlg );
		
		//FSRS_SIGNATURE
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//	Print(L"Structure: %s\n", readBuffer);
	
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		paramsSign->auth.signature.hashAlg = (UINT16) u64offset;	
		//Print(L"paramsSign->auth.signature.hashAlg: 0x%x \n", paramsSign->auth.signature.hashAlg );
		
		//read the type of policy structure from the file
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
		
		if( StrCmp( readBuffer, L"//FSR2B_PUBLIC_KEY" ) == 0 ) {
			if( read_FSR2B_KEY(FileHandle, &signature) ) {
				CopyMem( &paramsSign->auth.signature.signature, &signature, sizeof(FSR2B_PUBLIC_KEY) );
				//Print(L"paramsSign->encryptedSalt.Size: 0x%d\n", paramsSign->encryptedSalt.Size );
			}
		}
	
	}
	
}

BOOLEAN read_T2T_POLA_SECRET(EFI_FILE_HANDLE *FileHandle, T2T_POLA_SECRET *paramsSecret) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;
	FSR2B_NONCE		nonceTPM;
	FSR2B_DIGEST	cpHashA;
	FSR2B_NONCE		policyRef;
	FSR2B_PUBLIC_KEY	signature;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsSecret->authObjHandle = (UINT32) u64offset;	
	//Print(L"paramsSecret->authObjHandle: 0x%x \n", paramsSecret->authObjHandle );
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_NONCE" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &nonceTPM) ) {
			CopyMem( &paramsSecret->nonceTPM, &nonceTPM, sizeof(FSR2B_DIGEST) );
			//Print(L"paramsSecret->encryptedSalt.Size: 0x%d\n", paramsSecret->encryptedSalt.Size );
		}
	}
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &cpHashA) ) {
			CopyMem( &paramsSecret->cpHashA, &cpHashA, sizeof(FSR2B_NONCE) );
			//Print(L"paramsSecret->encryptedSalt.Size: 0x%d\n", paramsSecret->encryptedSalt.Size );
		}
	}
	
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_NONCE" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &policyRef) ) {
			CopyMem( &paramsSecret->policyRef, &policyRef, sizeof(FSR2B_NONCE) );
			//Print(L"paramsSecret->encryptedSalt.Size: 0x%d\n", paramsSecret->encryptedSalt.Size );
		}
	}
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsSecret->expiration = (UINT32) u64offset;	
	//Print(L"paramsSecret->expiration: 0x%x \n", paramsSecret->expiration );
	
}

BOOLEAN read_T2T_POLA_TICKET(EFI_FILE_HANDLE *FileHandle, T2T_POLA_TICKET *paramsTicket) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;

	FSR2B_DIGEST	cpHashA;
	FSR2B_NONCE		policyRef;
	FSR2B_NAME		authName;
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	//FSE2B_TIMEOUT	timeout;	//PolTicket,
	if( StrCmp( readBuffer, L"//FSE2B_TIMEOUT" ) == 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		paramsTicket->timeout.size = (UINT16) u64offset;	
		//Print(L"paramsTicket->timeout.size: 0x%x \n", paramsTicket->timeout.size );	
		
		pnvDataBuffer = &paramsTicket->timeout.buffer;
		ZeroMem ( pnvDataBuffer, T2T_MAX_KEY );
		if ( paramsTicket->timeout.size > 0 ) {
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			token = mystrtok(readBuffer, &delim);
			token = mystrtok(NULL, &delim);
			u64offset = 0;
			CopyMem(responseBuffer, token, StrLen(token) * 2);
					
			for ( i = 1; i < StrLen(token); i+=2 ) {				

				responseByte[0] = responseBuffer[i];
				responseByte[1] = responseBuffer[i + 1];
				responseByte[2] = CHAR_NULL;
				
				Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
							
				CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
				pnvDataBuffer++;
				u64offset = 0;
				ZeroMem(responseByte, 4);			
			}
			/*
			Print(L"Buffer: ");
			for (i = 0; i < paramsTicket->timeout.size; i++ ) {
				Print(L"%02x ",  paramsTicket->timeout.buffer[i] );
			}
			Print(L"\n");
			*/
		} else {
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			//Print(L"Buffer: \n");
		}
	}
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &cpHashA) ) {
			CopyMem( &paramsTicket->cpHashA, &cpHashA, sizeof(FSR2B_DIGEST) );
			//Print(L"paramsTicket->encryptedSalt.Size: 0x%d\n", paramsTicket->encryptedSalt.Size );
		}
	}
	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_NONCE" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &policyRef) ) {
			CopyMem( &paramsTicket->policyRef, &policyRef, sizeof(FSR2B_NONCE) );
			//Print(L"paramsTicket->encryptedSalt.Size: 0x%d\n", paramsTicket->encryptedSalt.Size );
		}
	}
	
	//FSR2B_NAME
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_NAME" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &authName) ) {
			CopyMem( &paramsTicket->authName, &authName, sizeof(FSR2B_NAME) );
			//Print(L"paramsTicket->encryptedSalt.Size: 0x%d\n", paramsTicket->encryptedSalt.Size );
		}
	}
	
	//T2P_TPM2B_100		authName;	//PolTicket, 
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//T2P_TPM2B_100" ) == 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		paramsTicket->ticket.size = (UINT16) u64offset;	
		//Print(L"paramsTicket->ticket.size: 0x%x \n", paramsTicket->ticket.size );	
		
		pnvDataBuffer = &paramsTicket->ticket.buffer;
		ZeroMem ( pnvDataBuffer, T2T_MAX_KEY );
		if ( paramsTicket->ticket.size > 0 ) {
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			token = mystrtok(readBuffer, &delim);
			token = mystrtok(NULL, &delim);
			u64offset = 0;
			CopyMem(responseBuffer, token, StrLen(token) * 2);
					
			for ( i = 1; i < StrLen(token); i+=2 ) {				

				responseByte[0] = responseBuffer[i];
				responseByte[1] = responseBuffer[i + 1];
				responseByte[2] = CHAR_NULL;
				
				Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
							
				CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
				pnvDataBuffer++;
				u64offset = 0;
				ZeroMem(responseByte, 4);			
			}
			/*
			Print(L"Buffer: ");
			for (i = 0; i < paramsTicket->ticket.size; i++ ) {
				Print(L"%02x ",  paramsTicket->ticket.buffer[i] );
			}
			Print(L"\n");
			*/
		} else {
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			//Print(L"Buffer: \n");
		}
			
	}
	
	//read //PDEF_CONT
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsTicket->reserved = (UINT32) u64offset;	
	//Print(L"paramsTicket->reserved: 0x%x \n", paramsTicket->reserved );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsTicket->reserved1 = (UINT32) u64offset;	
	//Print(L"paramsTicket->reserved1: 0x%x \n", paramsTicket->reserved1 );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsTicket->reserved2 = (UINT32) u64offset;	
	//Print(L"paramsTicket->reserved2: 0x%x \n", paramsTicket->reserved2 );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsTicket->reserved3 = (UINT32) u64offset;	
	//Print(L"paramsTicket->reserved3: 0x%x \n", paramsTicket->reserved3 );
	
}

BOOLEAN read_T2T_POLA_OR(EFI_FILE_HANDLE *FileHandle, T2T_POLA_OR *paramsOR) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;

	FSR2B_DIGEST	digests;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsOR->digestCount = (UINT32) u64offset;	
	//Print(L"paramsOR->digestCount: 0x%x \n", paramsOR->digestCount );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &digests) ) {
			CopyMem( &paramsOR->digests[0], &digests, sizeof(FSR2B_DIGEST) );
			//Print(L"paramsOR->encryptedSalt.Size: 0x%d\n", paramsOR->encryptedSalt.Size );
		}
		
		for ( i = 1; i < 8; i++ ) {
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			//Print(L"Structure: %s\n", readBuffer);
			
			ZeroMem( &digests, sizeof(FSR2B_DIGEST) );
			
			if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
				if( read_FSR2B_AUTH(FileHandle, &digests) ) {
					CopyMem( &paramsOR->digests[i], &digests, sizeof(FSR2B_DIGEST) );
					//Print(L"paramsOR->encryptedSalt.Size: 0x%d\n", paramsOR->encryptedSalt.Size );
				}
			}
		}
	}
	
	//read //PDEF_CONT
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	paramsOR->reserved = (UINT32) u64offset;	
	//Print(L"paramsOR->reserved: 0x%x \n", paramsOR->reserved );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	paramsOR->reserved1 = (UINT32) u64offset;	
	//Print(L"paramsOR->reserved1: 0x%x \n", paramsOR->reserved1 );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	paramsOR->reserved2 = (UINT32) u64offset;	
	//Print(L"paramsOR->reserved2: 0x%x \n", paramsOR->reserved2 );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	paramsOR->reserved3 = (UINT32) u64offset;	
	//Print(L"paramsOR->reserved3: 0x%x \n", paramsOR->reserved3 );
	
	return TRUE;
}

BOOLEAN read_FSES_PCR_SELECTION(EFI_FILE_HANDLE *FileHandle, FSES_PCR_SELECTION *pcrs) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;

	FSR2B_DIGEST		pcrDigest;
	//TPMI_ALG_HASH	hashAlg;				// hash algorithm associated with the selection
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pcrs->hashAlg = (UINT16) u64offset;	
	//Print(L"pcrs->hashAlg: 0x%x \n", pcrs->hashAlg );
	
	//UINT8			sizeOfSelect;			// size of the pcrSelect array
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pcrs->sizeOfSelect = (UINT8) u64offset;	
	//Print(L"pcrs->sizeOfSelect: 0x%x \n", pcrs->sizeOfSelect );
	
	//BYTE			pcrSelect[T2T_MAX_SOS]; // the bit map of selected PCR
	pnvDataBuffer = &pcrs->pcrSelect;
	ZeroMem ( pnvDataBuffer, 4 );
		
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	CopyMem(responseBuffer, token, StrLen(token) * 2);
			
	for ( i = 1; i < StrLen(token); i+=2 ) {				

		responseByte[0] = responseBuffer[i];
		responseByte[1] = responseBuffer[i + 1];
		responseByte[2] = CHAR_NULL;
		
		Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
					
		CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
		pnvDataBuffer++;
		u64offset = 0;
		ZeroMem(responseByte, 4);			
	}
	/*
	Print(L"Buffer: ");
	for (i = 0; i < 4; i++ ) {
		Print(L"%02x ",  pcrs->pcrSelect[i] );
	}
	Print(L"\n");
	*/

	return TRUE;
}

BOOLEAN read_T2T_POLA_PCR(EFI_FILE_HANDLE *FileHandle, T2T_POLA_PCR *paramsPCR) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;

	FSR2B_DIGEST		pcrDigest;
	FSES_PCR_SELECTION 	pcrs;
	
	//FSR2B_DIGEST
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &pcrDigest) ) {
			CopyMem( &paramsPCR->pcrDigest, &pcrDigest, sizeof(FSR2B_DIGEST) );
			//Print(L"paramsPCR->encryptedSalt.Size: 0x%d\n", paramsPCR->encryptedSalt.Size );
		}
	}
	
	//FSES_PCR_SELECTION
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//FSES_PCR_SELECTION" ) == 0 ) {
		if( read_FSES_PCR_SELECTION(FileHandle, &pcrs) ) {
			CopyMem( &paramsPCR->pcrs, &pcrs, sizeof(FSES_PCR_SELECTION) );
			//Print(L"paramsPCR->encryptedSalt.Size: 0x%d\n", paramsPCR->encryptedSalt.Size );
		}
	}
	
	//read //PDEF_CONT
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsPCR->reserved = (UINT32) u64offset;	
	//Print(L"paramsPCR->reserved: 0x%x \n", paramsPCR->reserved );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsPCR->reserved1 = (UINT32) u64offset;	
	//Print(L"paramsPCR->reserved1: 0x%x \n", paramsPCR->reserved1 );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsPCR->reserved2 = (UINT32) u64offset;	
	//Print(L"paramsPCR->reserved2: 0x%x \n", paramsPCR->reserved2 );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsPCR->reserved3 = (UINT32) u64offset;	
	//Print(L"paramsPCR->reserved3: 0x%x \n", paramsPCR->reserved3 );
	
	return TRUE;
}

BOOLEAN read_T2T_POLA_NV(EFI_FILE_HANDLE *FileHandle, T2T_POLA_NV *paramsNV) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;

	FSE2B_OPERAND 	operandB;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsNV->authHandle = (UINT32) u64offset;	
	//Print(L"paramsNV->authHandle: 0x%x \n", paramsNV->authHandle );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsNV->nvIndex = (UINT32) u64offset;	
	//Print(L"paramsNV->nvIndex: 0x%x \n", paramsNV->nvIndex );
	
	//FSE2B_OPERAND
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//FSE2B_OPERAND" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &operandB) ) {
			CopyMem( &paramsNV->operandB, &operandB, sizeof(FSE2B_OPERAND) );
			//Print(L"paramsNV->encryptedSalt.Size: 0x%d\n", paramsNV->encryptedSalt.Size );
		}
	}
	
	//PDEF_CONT
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsNV->offset = (UINT16) u64offset;	
	//Print(L"paramsNV->offset: 0x%x \n", paramsNV->offset );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsNV->operation = (UINT16) u64offset;	
	//Print(L"paramsNV->operation: 0x%x \n", paramsNV->operation );
	
	return TRUE;
}

BOOLEAN read_T2T_POLA_CNTRTIMER(EFI_FILE_HANDLE *FileHandle, T2T_POLA_CNTRTIMER *paramsCT) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;

	FSE2B_OPERAND 	operandB;
	
	//FSE2B_OPERAND
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//FSE2B_OPERAND" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &operandB) ) {
			CopyMem( &paramsCT->operandB, &operandB, sizeof(FSE2B_OPERAND) );
			//Print(L"paramsCT->encryptedSalt.Size: 0x%d\n", paramsCT->encryptedSalt.Size );
		}
	}
	
	//PDEF_CONT
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsCT->offset = (UINT16) u64offset;	
	//Print(L"paramsCT->offset: 0x%x \n", paramsCT->offset );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	paramsCT->operation = (UINT16) u64offset;	
	//Print(L"paramsCT->operation: 0x%x \n", paramsCT->operation );
	
	return TRUE;
}

BOOLEAN read_T2T_DATA(EFI_FILE_HANDLE *FileHandle, T2T_DATA *pT2TData) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[T2T_MAX_DATA * 2];
	CHAR16			delim[25] = L":";
	UINTN 			size = T2T_MAX_DATA * 2;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[T2T_MAX_DATA * 2] = L"";
	UINT32			i = 0;
	UINT32			index = 0;

	//source
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pT2TData->source = (UINT8) u64offset;	
	//Print(L"pT2TData->source: 0x%x \n", pT2TData->source );	

	//provType
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pT2TData->provType = (UINT8) u64offset;	
	//Print(L"pT2TData->provType: 0x%x \n", pT2TData->provType );	

	//provIndex
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pT2TData->provIndex = (UINT16) u64offset;	
	//Print(L"pT2TData->provIndex: 0x%x \n", pT2TData->provIndex );	

	//size
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pT2TData->size = (UINT16) u64offset;	
	//Print(L"pT2TData->size: 0x%x \n", pT2TData->size );	
	
	//read buffer
	pnvDataBuffer = &pT2TData->buffer;
	ZeroMem ( pnvDataBuffer, T2T_MAX_DATA );
	if ( pT2TData->size > 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Read Buffer: ");
		//for (i = 0; i < (pTp2Data->size * 2) + 9; i++ ) {
		//	Print(L"%c ",  readBuffer[i] );
		//}
		//Print(L"\n");
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		CopyMem(responseBuffer, token, StrLen(token) * 2);
		//Print(L"string length token: %d\n", StrLen(token) );
		for ( i = 1; i < StrLen(token); i+=2 ) {				

			responseByte[0] = responseBuffer[i];
			responseByte[1] = responseBuffer[i + 1];
			responseByte[2] = CHAR_NULL;
			
			Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );

			//memcpy(&pTp2Data->buffer[index], &test, 1);
			//CopyMem(&pTp2Data->buffer[index], (UINT8 *)&u64offset, 1);
			pT2TData->buffer[index] = (UINT8 )u64offset;
			index++;
			//CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
			//pnvDataBuffer++;
			u64offset = 0;
			ZeroMem(responseByte, 4);			
		}
		/*
		Print(L"Buffer: ");
		for (i = 0; i < pT2TData->size; i++ ) {
			Print(L"%02x ",  pT2TData->buffer[i] );
		}
		Print(L"\n");
		*/
	} else {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Buffer: \n");
	}

	return TRUE;
}

BOOLEAN read_T2T_POLA_AUTHORIZE(EFI_FILE_HANDLE *FileHandle, T2T_POLA_AUTHORIZE *paramsAuth) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	UINT32			i = 0;

	T2T_DATA		pT2TData;

	//APPROVED_POLICY
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	//T2T_DATA
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2T_DATA" ) == 0 ) {
		if( read_T2T_DATA(FileHandle, &pT2TData ) ) {
			CopyMem( &paramsAuth->approvedPolicy, &pT2TData, sizeof(T2T_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	//POLICY_REF
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	//T2T_DATA
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2T_DATA" ) == 0 ) {
		if( read_T2T_DATA(FileHandle, &pT2TData ) ) {
			CopyMem( &paramsAuth->policyRef, &pT2TData, sizeof(T2T_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	//KEY_SIGN
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	//T2T_DATA
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2T_DATA" ) == 0 ) {
		if( read_T2T_DATA(FileHandle, &pT2TData ) ) {
			CopyMem( &paramsAuth->keySign, &pT2TData, sizeof(T2T_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	//CHECK_TICKET
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	//T2T_DATA
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2T_DATA" ) == 0 ) {
		if( read_T2T_DATA(FileHandle, &pT2TData ) ) {
			CopyMem( &paramsAuth->checkTicket, &pT2TData, sizeof(T2T_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	return TRUE;
}

BOOLEAN read_T2T_POLICY_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_POLICY_DEF_FILE *pDef) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;
	
	T2T_POLA_SIGNED		paramsSign;	//assertion = TPM_CC_PolicySigned
	T2T_POLA_SECRET		paramsSecret;	//assertion = TPM_CC_PolicySecret
	T2T_POLA_TICKET		paramsTicket;	//;assertion = TPM_CC_PolicyTicket
	T2T_POLA_OR			paramsOR;	//;assertion = TPM_CC_PolicyOR
	T2T_POLA_PCR		paramsPCR;	//;assertion = TPM_CC_PolicyPCR
	T2T_POLA_LOCALITY	paramsLOC;	//;assertion = TPM_CC_PolicyLocality
	T2T_POLA_NV			paramsNV;	//;assertion = TPM_CC_PolicyNV 
	T2T_POLA_CNTRTIMER	paramsCT;	//;assertion = TPM_CC_PolicyCounterTimer
	T2T_POLA_CC			paramsCC;	//;assertion = TPM_CC_PolicyCommandCode
	T2T_POLA_CPHASH		paramsCp;	//;assertion = TPM_CC_PolicyCpHash
	T2T_POLA_NAMEHASH	paramsName;	//;assertion = TPM_CC_PolicyNameHash
	T2T_POLA_DUP		paramsDup;	//;assertion = TPM_CC_PolicyDuplicationSelect
	T2T_POLA_AUTHORIZE	paramsAuth;	//;assertion = TPM_CC_PolicyAuthorize
	T2T_POLA_NULL		noParams;	//;assertion = TPM_CC_PolicyAuthValue  or
									//      TPM_CC_PolicyPhysicalPresence  or
									//      TPM_CC_PolicyPassword
										

	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pDef->assertion = (UINT32) u64offset;	
	//Print(L"pDef->assertion: 0x%x \n", pDef->assertion );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pDef->reserved = (UINT32) u64offset;	
	//Print(L"pDef->reserved: 0x%x \n", pDef->reserved );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pDef->reserved1 = (UINT32) u64offset;	
	//Print(L"pDef->reserved1: 0x%x \n", pDef->reserved1 );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	pDef->reserved2 = (UINT32) u64offset;	
	//Print(L"pDef->reserved2: 0x%x \n", pDef->reserved2 );	
	
	//read the T2TU_POL_PARAMS structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//T2T_POLA_SIGNED" ) == 0 ) {
		if( read_T2T_POLA_SIGNED(FileHandle, &paramsSign ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS.paramsSign, &paramsSign, sizeof(T2T_POLA_SIGNED) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_SECRET" ) == 0 ) {
		if( read_T2T_POLA_SECRET(FileHandle, &paramsSecret ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS.paramsSecret, &paramsSecret, sizeof(T2T_POLA_SECRET) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_TICKET" ) == 0 ) {
		if( read_T2T_POLA_SIGNED(FileHandle, &paramsTicket ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS, &paramsTicket, sizeof(T2T_POLA_TICKET) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_OR" ) == 0 ) {
		if( read_T2T_POLA_OR(FileHandle, &paramsOR ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS, &paramsOR, sizeof(T2T_POLA_OR) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_PCR" ) == 0 ) {
		if( read_T2T_POLA_PCR(FileHandle, &paramsPCR ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS, &paramsPCR, sizeof(T2T_POLA_PCR) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_LOCALITY" ) == 0 ) {
		UINT8 locality;
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
		locality = (UINT8) u64offset;	
		CopyMem( &pDef->T2TU_POL_PARAMS.paramsLOC.locality, &locality, 1);
		//Print(L"pDef->T2TU_POL_PARAMS.paramsLOC.locality: 0x%x \n", pDef->T2TU_POL_PARAMS.paramsLOC.locality );	
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_NV" ) == 0 ) {
		if( read_T2T_POLA_NV(FileHandle, &paramsNV ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS, &paramsNV, sizeof(T2T_POLA_NV) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_CNTRTIMER" ) == 0 ) {
		if( read_T2T_POLA_CNTRTIMER(FileHandle, &paramsCT ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS, &paramsCT, sizeof(T2T_POLA_CNTRTIMER) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_CC" ) == 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		pDef->T2TU_POL_PARAMS.paramsCC.code = (UINT32) u64offset;	
		//Print(L"pDef->T2TU_POL_PARAMS.paramsCC.code: 0x%x \n", pDef->T2TU_POL_PARAMS.paramsCC.code );	
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_CPHASH" ) == 0 ) {
		FSR2B_DIGEST		cpHashA;
		//FSR2B_DIGEST
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);

		if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
			if( read_FSR2B_AUTH(FileHandle, &cpHashA) ) {
				CopyMem( &pDef->T2TU_POL_PARAMS.paramsCp.cpHashA, &cpHashA, sizeof(FSR2B_DIGEST) );
				//Print(L"paramsPCR->encryptedSalt.Size: 0x%d\n", paramsPCR->encryptedSalt.Size );
			}
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_NAMEHASH" ) == 0 ) {
		FSR2B_DIGEST		nameHash;
		//FSR2B_DIGEST
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);

		if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
			if( read_FSR2B_AUTH(FileHandle, &nameHash) ) {
				CopyMem( &pDef->T2TU_POL_PARAMS.paramsName.nameHash, &nameHash, sizeof(FSR2B_DIGEST) );
				//Print(L"paramsPCR->encryptedSalt.Size: 0x%d\n", paramsPCR->encryptedSalt.Size );
			}
		}
	}
	
	//lowest priority since we'll probably never use this type of policy assertion
	if( StrCmp( readBuffer, L"//T2T_POLA_DUP" ) == 0 ) {
		if( read_T2T_POLA_SIGNED(FileHandle, &paramsDup ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS, &paramsDup, sizeof(T2T_POLA_DUP) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_AUTHORIZE" ) == 0 ) {
		if( read_T2T_POLA_AUTHORIZE(FileHandle, &paramsAuth ) ) {
			CopyMem( &pDef->T2TU_POL_PARAMS, &paramsAuth, sizeof(T2T_POLA_AUTHORIZE) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_NV_WRITTEN" ) == 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		pDef->T2TU_POL_PARAMS.paramsNvWritten.writtenSet = (UINT8) u64offset;	
		//Print(L"pDef->T2TU_POL_PARAMS.paramsNvWritten.writtenSet: 0x%x \n", pDef->T2TU_POL_PARAMS.paramsNvWritten.writtenSet );	
	}
	
	if( StrCmp( readBuffer, L"//T2T_POLA_NULL" ) == 0 ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		pDef->T2TU_POL_PARAMS.noParams.reserved = (UINT32) u64offset;	
		//Print(L"pDef->T2TU_POL_PARAMS.noParams.reserved: 0x%x \n", pDef->T2TU_POL_PARAMS.noParams.reserved );	
	}
	
	
}

BOOLEAN read_T2T_DIGEST_LIST_FILE( EFI_FILE_HANDLE *FileHandle, T2T_DIGEST_LIST_FILE *digestListFile ) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;
	
	FSR2B_DIGEST		digest;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	digestListFile->alg = (UINT32) u64offset;	
	//Print(L"digestListFile->alg: 0x%x \n", digestListFile->alg );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	digestListFile->count = (UINT32) u64offset;	
	//Print(L"digestListFile->count: 0x%x \n", digestListFile->count );	
	
	for ( i = 0; i < 24; i++ ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);

		ZeroMem( &digest, sizeof(FSR2B_DIGEST) );
		if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
			if( read_FSR2B_AUTH(FileHandle, &digest) ) {
				CopyMem( &digestListFile->digest[i], &digest, sizeof(FSR2B_DIGEST) );
				//Print(L"paramsPCR->encryptedSalt.Size: 0x%d\n", paramsPCR->encryptedSalt.Size );
			}
		}
	}
	
	return TRUE;
}

BOOLEAN read_T2T_POL_SET_FILE( EFI_FILE_HANDLE *FileHandle, T2T_POL_SET_FILE *polSetFile ) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	
	FSR2B_DIGEST		digest;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	polSetFile->hierarchy = (UINT32) u64offset;	
	//Print(L"polSetFile->hierarchy: 0x%x \n", polSetFile->hierarchy );
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	polSetFile->alg = (UINT16) u64offset;	
	//Print(L"polSetFile->alg: 0x%x \n", polSetFile->alg );	
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	ZeroMem( &digest, sizeof(FSR2B_DIGEST) );
	if( StrCmp( readBuffer, L"//FSR2B_DIGEST" ) == 0 ) {
		if( read_FSR2B_AUTH(FileHandle, &digest) ) {
			CopyMem( &polSetFile->digest, &digest, sizeof(FSR2B_DIGEST) );
			//Print(L"paramsPCR->encryptedSalt.Size: 0x%d\n", paramsPCR->encryptedSalt.Size );
		}
	}

	return TRUE;
}

BOOLEAN read_TPMU_PUBLIC_PARMS( EFI_FILE_HANDLE *FileHandle, TPMU_PUBLIC_PARMS *publicParams )
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;	


	//read the type of policy structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	
	if( StrCmp( readBuffer, L"//TPMS_RSA_PARMS" ) == 0 ) {

		//TPMT_SYM_DEF_OBJECT
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		publicParams->rsaDetail.symmetric.algorithm = (UINT16) u64offset;	
		//Print(L"publicParams->rsaDetail.symmetric: 0x%x \n", publicParams->rsaDetail.symmetric.algorithm );	

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		//publicParams->rsaDetail.symmetric.keyBits = (UINT16) u64offset;
		CopyMem( &publicParams->rsaDetail.symmetric.keyBits, &u64offset, sizeof(UINT16) );
		//Print(L"publicParams->rsaDetail.symmetric.details: 0x%x \n", publicParams->rsaDetail.symmetric.keyBits );	

		//memcopy the field since we know this mode is a UINT16
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		//publicParams->rsaDetail.symmetric.mode = (UINT16) u64offset;	
		CopyMem( &publicParams->rsaDetail.symmetric.mode, &u64offset, sizeof(UINT16) );
		//Print(L"publicParams->rsaDetail.symmetric.details: 0x%x \n", publicParams->rsaDetail.symmetric.mode );
		
		//read the type of TPMT_RSA_SCHEME
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
	
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		publicParams->rsaDetail.scheme.scheme = (UINT16) u64offset;	
		//Print(L"publicParams->rsaDetail.sign.scheme: 0x%x \n", publicParams->rsaDetail.scheme.scheme );	

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		//publicParams->rsaDetail.scheme.details = (UINT16) u64offset;	
		CopyMem( &publicParams->rsaDetail.scheme.details, &u64offset, sizeof(UINT16) );
		//Print(L"publicParams->rsaDetail.sign.details: 0x%x \n", publicParams->rsaDetail.scheme.details );	

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		publicParams->rsaDetail.keyBits = (UINT16) u64offset;	
		//Print(L"publicParams->rsaDetail.keyBits: 0x%x \n", publicParams->rsaDetail.keyBits );	

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		publicParams->rsaDetail.exponent = (UINT32) u64offset;	
		//Print(L"publicParams->rsaDetail.exponent: 0x%x \n", publicParams->rsaDetail.exponent );	
		
			
	}
	
	if( StrCmp( readBuffer, L"//TPMS_ECC_PARMS" ) == 0 ) {
		
	}
	
	if( StrCmp( readBuffer, L"//TPMS_KEYEDHASH_PARMS" ) == 0 ) {
		
	}
	
	if( StrCmp( readBuffer, L"//TPMS_AES_PARMS" ) == 0 ) {
		
	}
	
	if( StrCmp( readBuffer, L"//TPMS_SMS4_PARMS" ) == 0 ) {
		
	}

	return TRUE;
}

BOOLEAN read_T2T_K_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_K_DEF_FILE *kDef) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	TPM2B_PUBLIC	inPublic;
	FSR2B_KEY 		fsr2bKey;
	FSR2B_AUTH 		fsr2bAuth;
	FSR2B_DATABUF 	fsr2bDataBuffer;
	TPMU_PUBLIC_PARMS parameters;
	TPML_PCR_SELECTION	creationPCR;
	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;
	UINT32			j = 0;
	
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	kDef->hierarchy = (UINT32) u64offset;	
	//Print(L"kDef->hierarchy: 0x%x \n", kDef->hierarchy );	
	
	//read the TPM2B_SENSITIVE_CREATE structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_SENSITIVE_CREATE" ) == 0 ) {

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		kDef->inSensitive.size = (UINT16) u64offset;	
		//Print(L"kDef->inSensitive.size: 0x%x \n", kDef->inSensitive.size );	
	
		//FSRS_SENSITIVE_CREATE
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);

		//FSR2B_AUTH
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
		if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
			if( read_FSR2B_AUTH(FileHandle, &fsr2bAuth ) ) {
				CopyMem( &kDef->inSensitive.sensitive.userAuth, &fsr2bAuth, sizeof(FSR2B_AUTH) );
				//Print(L"kDef->inSensitive.userAuth: 0x%d\n", kDef->inSensitive.sensitive.userAuth );
			}
		}

		//FSR2B_KEY
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
		if( StrCmp( readBuffer, L"//FSR2B_KEY" ) == 0 ) {
			if( read_FSR2B_AUTH(FileHandle, &fsr2bKey ) ) {
				CopyMem( &kDef->inSensitive.sensitive.data, &fsr2bKey, sizeof(FSR2B_KEY) );
				//Print(L"kDef->inSensitive.data: 0x%d\n", kDef->inSensitive.sensitive.data );
			}
		}
	}
	
	//read the TPM2B_PUBLIC structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//TPM2B_PUBLIC" ) == 0 ) {

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		kDef->inPublic.size = (UINT16) u64offset;	
		//Print(L"kDef->inPublic.size: 0x%x \n", kDef->inPublic.size );	

		//read the TPMT_PUBLIC structure from the file
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		kDef->inPublic.publicArea.type = (UINT16) u64offset;	
		//Print(L"kDef->inPublic.publicArea.type: 0x%x \n", kDef->inPublic.publicArea.type );	

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		kDef->inPublic.publicArea.nameAlg = (UINT16) u64offset;	
		//Print(L"kDef->inPublic.publicArea.nameAlg: 0x%x \n", kDef->inPublic.publicArea.nameAlg );	

		//memcopy the bit field into the location.
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		CopyMem( &kDef->inPublic.publicArea.objectAttributes, &u64offset, sizeof(UINT32) );
		//Print(L"kDef->inPublic.publicArea.objectAttributes: 0x%x \n", kDef->inPublic.publicArea.objectAttributes );	

		//FSR2B_AUTH
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
		if( StrCmp( readBuffer, L"//FSR2B_AUTH" ) == 0 ) {
			if( read_FSR2B_AUTH(FileHandle, &fsr2bAuth ) ) {
				CopyMem( &kDef->inPublic.publicArea.authPolicy, &fsr2bAuth, sizeof(FSR2B_AUTH) );
				//Print(L"kDef->inSensitive.userAuth: 0x%d\n", kDef->inSensitive.sensitive.userAuth );
			}
		}

		//TPMU_PUBLIC_PARMS
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
		if( StrCmp( readBuffer, L"//TPMU_PUBLIC_PARMS" ) == 0 ) {
			if( read_TPMU_PUBLIC_PARMS(FileHandle, &parameters ) ) {
				CopyMem( &kDef->inPublic.publicArea.parameters, &parameters, sizeof(TPMU_PUBLIC_PARMS) );
				//Print(L"kDef->inSensitive.userAuth: 0x%d\n", kDef->inSensitive.sensitive.userAuth );
			}
		}

		//FSR2B_KEY
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		//Print(L"Structure: %s\n", readBuffer);
		if( StrCmp( readBuffer, L"//FSR2B_KEY" ) == 0 ) {
			if( read_FSR2B_AUTH(FileHandle, &fsr2bKey ) ) {
				CopyMem( &kDef->inPublic.publicArea.unique, &fsr2bKey, sizeof(FSR2B_KEY) );
				//Print(L"kDef->inSensitive.data: 0x%d\n", kDef->inSensitive.sensitive.data );
			}
		}

	}
	
	//read the FSR2B_DATABUF structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FSR2B_DATABUF" ) == 0 ) {
		if( read_FSR2B_DATABUF(FileHandle, &fsr2bDataBuffer ) ) {
			CopyMem( &kDef->outsideInfo, &fsr2bDataBuffer, sizeof(FSR2B_DATABUF) );
			//Print(L"kDef->dataSource.size: 0x%x\n", kDef->dataSource.size );
		}
	}
	
	//read the TPML_PCR_SELECTION structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//TPML_PCR_SELECTION" ) == 0 ) {

		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		kDef->creationPCR.count = (UINT32) u64offset;	
		//Print(L"kDef->creationPCR.count: 0x%x \n", kDef->creationPCR.count );	

		for ( j = 0; j < 6; j++ ) {
			//TPMS_PCR_SELECTION
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			//Print(L"Structure: %s\n", readBuffer);

			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			token = mystrtok(readBuffer, &delim);
			token = mystrtok(NULL, &delim);
			u64offset = 0;
			Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
			kDef->creationPCR.pcrSelections[j].hash = (UINT32) u64offset;	
			//Print(L"kDef->creationPCR.pcrSelections[j].hash: 0x%x \n", kDef->creationPCR.pcrSelections[j].hash );	

			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			token = mystrtok(readBuffer, &delim);
			token = mystrtok(NULL, &delim);
			u64offset = 0;
			Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
			kDef->creationPCR.pcrSelections[j].sizeofSelect = (UINT32) u64offset;	
			//Print(L"kDef->creationPCR.pcrSelections[j].sizeofselect: 0x%x \n", kDef->creationPCR.pcrSelections[j].sizeofSelect );	

			pnvDataBuffer = &kDef->creationPCR.pcrSelections[j].pcrSelect[0];
			ZeroMem ( pnvDataBuffer, 3 );
			Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
			token = mystrtok(readBuffer, &delim);
			token = mystrtok(NULL, &delim);
			u64offset = 0;
			CopyMem(responseBuffer, token, StrLen(token) * 2);
				
			for ( i = 1; i < StrLen(token); i+=2 ) {				

				responseByte[0] = responseBuffer[i];
				responseByte[1] = responseBuffer[i + 1];
				responseByte[2] = CHAR_NULL;
			
				Status = ShellConvertStringToUint64(responseByte, &u64offset,  TRUE,  TRUE );
						
				CopyMem(pnvDataBuffer, (UINT8 *)&u64offset, 1);
				pnvDataBuffer++;
				u64offset = 0;
				ZeroMem(responseByte, 4);			
			}
			/*
			Print(L"Buffer: ");
			for (i = 0; i < 3; i++ ) {
				Print(L"%02x ",  kDef->creationPCR.pcrSelections[j].pcrSelect[i] );
			}
			Print(L"\n");
			*/
		}

	}

	return TRUE;
}

BOOLEAN read_T2T_CDEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_CDEF_FILE *cDef) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	CHAR16			*token = NULL;
	BOOLEAN 		ascii = FALSE;
	UINT64 			u64offset;
	FSR2B_DATABUF 	fsr2bDataBuffer;

	UINT8			*pnvDataBuffer;
	CHAR16			responseByte[3];
	CHAR16			responseBuffer[256] = L"";
	UINT32			i = 0;
	UINT32			j = 0;

	//cmdTyep
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->cmdType = (UINT8) u64offset;	
	Print(L"cDef->cmdType: 0x%x \n", cDef->cmdType );	

	//subType
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->subType = (UINT8) u64offset;	
	Print(L"cDef->subType: 0x%x \n", cDef->subType );	

	//CpEncrypt
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->CpEncrypt = (UINT8) u64offset;	
	Print(L"cDef->CpEncrypt: 0x%x \n", cDef->CpEncrypt );	

	//RpEncrypt
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->RpEncrypt = (UINT8) u64offset;	
	Print(L"cDef->RpEncrypt: 0x%x \n", cDef->RpEncrypt );	

	//cmdCode
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->cmdCode = (UINT32) u64offset;	
	Print(L"cDef->cmdCode: 0x%x \n", cDef->cmdCode );	

	//numHandles
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->numHandles = (UINT8) u64offset;	
	Print(L"cDef->numHandles: 0x%x \n", cDef->numHandles );	

	//read the //TPM_HANDLE 10
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);

	//handle[10]
	for ( i = 0; i < 10; i++ ) {
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->handle[i] = (UINT32) u64offset;	
		Print(L"cDef->handle[%d]: 0x%x \n", i, cDef->handle[i] );	
	}

	//OutHandle
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->OutHandle = (UINT8) u64offset;	
	Print(L"cDef->OutHandle: 0x%x \n", cDef->OutHandle );	

	//handleIndex
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->handleIndex = (UINT8) u64offset;	
	Print(L"cDef->handleIndex: 0x%x \n", cDef->handleIndex );	

	//read the //Cp structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);

	//numCommandParams
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->numCommandParams = (UINT8) u64offset;	
	Print(L"cDef->numCommandParams: 0x%x \n", cDef->numCommandParams );	

	//allocate buffer space for response params
	cDef->Cp = AllocateZeroPool( sizeof(T2T_PARAM_BLOCK) * cDef->numCommandParams );

	for ( i = 0; i < cDef->numCommandParams; i++ ) {

		//read the //T2T_PARAM_BLOCK 
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		Print(L"Structure: %s\n", readBuffer);

		//type
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->Cp[i].type = (UINT8) u64offset;	
		//Print(L"cDef->Cp[i].type: 0x%x \n", cDef->Cp[i].type );	

		//read the FSR2B_DATABUF Data
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		Print(L"Structure: %s\n", readBuffer);
		if( StrCmp( readBuffer, L"//FSR2B_DATABUF" ) == 0 ) {
			if( read_FSR2B_DATABUF(FileHandle, &fsr2bDataBuffer ) ) {
				CopyMem( &cDef->Cp[i].data, &fsr2bDataBuffer, sizeof(FSR2B_DATABUF) );
			}
		}

	}

	//read the //Rp structure from the file
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);

	//numResponseParams
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	cDef->numResponseParams = (UINT8) u64offset;	
	Print(L"cDef->numResponseParams: 0x%x \n", cDef->numResponseParams );	

	//allocate buffer space for response params
	cDef->Rp = AllocateZeroPool( sizeof(T2T_PARAM_BLOCK) * cDef->numResponseParams );


	for ( i = 0; i < cDef->numResponseParams; i++ ) {

		//read the //T2T_R_PARAM_BLOCK 
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		Print(L"Structure: %s\n", readBuffer);

		//rpType
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->Rp[i].rpType = (UINT8) u64offset;	
		Print(L"cDef->Rp[i].rpType: 0x%x \n", cDef->Rp[i].rpType );	

		//action
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->Rp[i].action = (UINT8) u64offset;	
		Print(L"cDef->Rp[i].action: 0x%x \n", cDef->Rp[i].action );	

		//rpSize
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->Rp[i].rpSize = (UINT16) u64offset;	
		Print(L"cDef->Rp[i].rpSize: 0x%x \n", cDef->Rp[i].rpSize );	

		//arrayName
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->Rp[i].arrayName = (UINT8) u64offset;	
		Print(L"cDef->Rp[i].arrayName: 0x%x \n", cDef->Rp[i].arrayName );	

		//arrayIndex
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->Rp[i].arrayIndex = (UINT8) u64offset;	
		Print(L"cDef->Rp[i].arrayIndex: 0x%x \n", cDef->Rp[i].arrayIndex );	

		//includeSize
		Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
		token = mystrtok(readBuffer, &delim);
		token = mystrtok(NULL, &delim);
		u64offset = 0;
		Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
		cDef->Rp[i].includeSize = (UINT8) u64offset;	
		Print(L"cDef->Rp[i].includeSize: 0x%x \n", cDef->Rp[i].includeSize );	

	
	}

	//reserved
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	cDef->reserved = (UINT32) u64offset;	
	Print(L"cDef->reserved: 0x%x \n", cDef->reserved );	

	//reserved1
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	cDef->reserved1 = (UINT32) u64offset;	
	Print(L"cDef->reserved1: 0x%x \n", cDef->reserved1 );

	//reserved2
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64( token, &u64offset, /*force hex*/ TRUE, /*stop at space*/ TRUE );	
	cDef->reserved2 = (UINT32) u64offset;	
	Print(L"cDef->reserved2: 0x%x \n", cDef->reserved2 );	

	return TRUE;
}

BOOLEAN read_T2P_SOBJ(EFI_FILE_HANDLE *FileHandle, T2T_SOBJ_FILE *sObj) 
{

	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;

	//TPM2B_PRIVATE 
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
		if( read_T2P_DATA( FileHandle, &sObj->encryptedPrivate ) ) {
			//Print(L" sObj->encryptedPrivate.size: 0x%x\n", sObj->encryptedPrivate.size );
		}	
	}

	//TPM2B_PUBLIC
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
		if( read_T2P_DATA( FileHandle, &sObj->keyPublic ) ) {
			//Print(L" sObj->keyPublic.size: 0x%x\n", sObj->keyPublic.size );
		}	
	}


	//TPM2B_CREATION_DATA
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
		if( read_T2P_DATA( FileHandle, &sObj->creationData ) ) {
			//Print(L" sObj->creationData.size: 0x%x\n", sObj->creationData.size );
		}	
	}
	

	
	//TPM2B_DIGEST
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_DIGEST" ) == 0 ) {
		if( read_T2P_AUTH( FileHandle, &sObj->creationHash ) ) {
			//Print(L" sObj->creationHash.size: 0x%x\n", sObj->creationHash.size );
		}	
	}

	//TPMT_TK_CREATION 
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_DIGEST" ) == 0 ) {
		if( read_T2P_AUTH( FileHandle, &sObj->creationTicket ) ) {
			//Print(L" sObj->creationTicket.size: 0x%x\n", sObj->creationTicket.size );
		}	
	}

	//TPM2B_NAME 
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2P_DIGEST" ) == 0 ) {
		if( read_T2P_AUTH( FileHandle, &sObj->name ) ) {
			//Print(L" sObj->name.size: 0x%x\n", sObj->name.size );
		}	
	}


	return 0;
}

BOOLEAN read_T2T_DUP_FILE(EFI_FILE_HANDLE *FileHandle, T2T_DUP_FILE *dDef) 
{
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	CHAR16			delim[25] = L":";
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	CHAR16			*token = NULL;
	UINT32			i = 0;
	UINT64 			u64offset;

	T2P_DATA		pT2PData;
	T2T_KEY			pT2TKey;

	//T2T_DUP_FILE
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	//iSymAlg
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	dDef->iSymAlg = (UINT16) u64offset;	
	//Print(L"dDef->iSymAlg: 0x%x \n", dDef->iSymAlg );	

	//iSymKeyBits
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	dDef->iSymKeyBits = (UINT16) u64offset;	
	//Print(L"dDef->iSymKeyBits: 0x%x \n", dDef->iSymKeyBits );	

	//iSymMode
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	token = mystrtok(readBuffer, &delim);
	token = mystrtok(NULL, &delim);
	u64offset = 0;
	Status = ShellConvertStringToUint64(token, &u64offset, /*force hex*/ FALSE, /*stop at space*/ TRUE);
	dDef->iSymMode = (UINT16) u64offset;	
	//Print(L"dDef->iSymMode: 0x%x \n", dDef->iSymMode );	


	//ISYMKEY
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2T_KEY" ) == 0 ) {
		if( read_T2T_DATA(FileHandle, &pT2TKey ) ) {
			CopyMem( &dDef->iSymKey, &pT2TKey, sizeof(T2T_KEY) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	//WRAPPEDPRIVATE
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
		if( read_T2P_DATA(FileHandle, &pT2PData ) ) {
			CopyMem( &dDef->wrappedPrivate, &pT2PData, sizeof(T2P_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	//OENCSEED
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
		if( read_T2P_DATA(FileHandle, &pT2PData ) ) {
			CopyMem( &dDef->oEncSeed, &pT2PData, sizeof(T2P_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	//PUBLICKKEY
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
		if( read_T2P_DATA(FileHandle, &pT2PData ) ) {
			CopyMem( &dDef->publicKey, &pT2PData, sizeof(T2P_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}

	//NAME
	Status = FileHandleReadLine(*FileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);

	if( StrCmp( readBuffer, L"//T2P_DATA" ) == 0 ) {
		if( read_T2P_DATA(FileHandle, &pT2PData ) ) {
			CopyMem( &dDef->name, &pT2PData, sizeof(T2P_DATA) );
			//Print(L"pDef->encryptedSalt.Size: 0x%d\n", pDef->encryptedSalt.Size );
		}
	}


	
	return TRUE;
}

/*********************************************************************************************************/

/*********************************Structure packing functions*********************************************/

UINT8 PackNonce(T2P_CMDAREA *pArea, T2T_SESSION_DEF_FILE *psDef)
{
	UINT32			i = 0;
	UINT16 			u16Temp = 0;
		
	//pack nonceSize - UINT16
	u16Temp = ChangeEndiannessWord( psDef->nonceSize );
	CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( psDef->nonceSize ));
	pArea->offset += sizeof( psDef->nonceSize );
	pArea->headroom -= sizeof( psDef->nonceSize );
	
	//Print(L"nonce size: 0x%x\n", psDef->nonceSize);
		
	for( i = pArea->offset; i < (pArea->offset + psDef->nonceSize); i++ ) {																	// 20
		pArea->buf[i] = 0xA5;					
	}
	pArea->offset += psDef->nonceSize;
	pArea->headroom -= psDef->nonceSize;

	/*
	if ( psDef->nonceType == NONCE_CONSTANT ) {
		Print(L"Constant nonce\n");
		Print(L"nonce size: 0x%x\n", psDef->nonceSize);
		
		for( i = pArea->offset; i < (pArea->offset + psDef->nonceSize); i++ ) {																	// 20
			pArea->buf[i] = 0xA5;					
		}
		pArea->offset += psDef->nonceSize;
		pArea->headroom -= psDef->nonceSize;
		
	} else if ( psDef->nonceType == NONCE_EMPTY ) {
		//check to make sure psDef.nonceSize is 0
		if ( psDef->nonceSize != 0 ) {
			Print(L"ERROR: Nonce type is EMPTY and non size > 0\n");
		}
	} else if ( psDef->nonceType == NONCE_RANDOM ) {
		//check to make sure psDef.nonceSize is 0
		for( i = pArea->offset; i < (pArea->offset + psDef->nonceSize); i++ ) {																	// 20
			pArea->buf[i] = 0xA5;		//TODO generate random value			
		}
		pArea->offset += psDef->nonceSize;
		pArea->headroom -= psDef->nonceSize;
	} else {
		Print(L"ERROR: Unrecognized nonce type\n");
	}
	*/

	return 0;
}

UINT8 Pack2B( T2P_AUTHAREA *pArea, T2P_AUTH *authValue )
{
	UINT16 			u16Temp = 0;
	
	u16Temp = ChangeEndiannessWord( authValue->size );
	CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( authValue->size ));
	pArea->offset += sizeof( authValue->size );
	pArea->headroom -= sizeof( authValue->size );
	
	//pack the salt value
	//DumpHexValue (L"DATA_BUFFER:", (UINT8 *) &authValue->buffer, authValue->size);
	//Print(L"pArea->offset: %d\n", pArea->offset);
	CopyMem( &pArea->buf[pArea->offset], &authValue->buffer, authValue->size );
	pArea->offset += authValue->size;
	pArea->headroom -= authValue->size;
			
	return 0;
}

UINT8 PackVDR(T2P_CMDAREA *pArea, VDR_DATABUF *pVDR, UINT16 size, T2P_CONFIG_FILE *sCfg)
{
	UINT16 			u16Temp = 0;
	
	//Print(L"pVDR->bufType: 0x%x\n", pVDR->bufType);
	
	if( pVDR->bufType == DATA_BUFFER ) { //1
		//Print(L"DATA_BUFFER\n");
		//Print(L"size: 0x%x\n", pVDR->size);
		//pack saltSize - UINT16
		u16Temp = ChangeEndiannessWord( pVDR->size );
		CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( pVDR->size ));
		pArea->offset += sizeof( pVDR->size );
		pArea->headroom -= sizeof( pVDR->size );
	
		//pack the salt value
		//DumpHexValue (L"DATA_BUFFER:", (UINT8 *) &pVDR->buffer, pVDR->size);
		//Print(L"pArea->offset: %d\n", pArea->offset);
		CopyMem( &pArea->buf[pArea->offset], &pVDR->buffer, pVDR->size );
		pArea->offset += pVDR->size;
		pArea->headroom -= pVDR->size;
	} else if( pVDR->bufType == NULL_BUFFER ) { //0
	
		//Print(L"NULL_BUFFER\n");
		if( pVDR->fileType == CONFIG_DIGEST ) { //#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->digest[pVDR->dataIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->digest[pVDR->dataIndex].size ));
			pArea->offset += sizeof( sCfg->digest[pVDR->dataIndex].size );
			pArea->headroom -= sizeof( sCfg->digest[pVDR->dataIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			pArea->offset += sCfg->digest[pVDR->dataIndex].size;
			pArea->headroom -= sCfg->digest[pVDR->dataIndex].size;
		} else if (pVDR->fileType == CONFIG_KEY ) { //#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->key[pVDR->dataIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->key[pVDR->dataIndex].size ));
			pArea->offset += sizeof( sCfg->key[pVDR->dataIndex].size );
			pArea->headroom -= sizeof( sCfg->key[pVDR->dataIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->key[pVDR->dataIndex].buffer, sCfg->key[pVDR->dataIndex].size );
			pArea->offset += sCfg->key[pVDR->dataIndex].size;
			pArea->headroom -= sCfg->key[pVDR->dataIndex].size;
		} else if (pVDR->fileType == CONFIG_AUTH ) { //#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->authValue[pVDR->dataIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->authValue[pVDR->dataIndex].size ));
			pArea->offset += sizeof( sCfg->authValue[pVDR->dataIndex].size );
			pArea->headroom -= sizeof( sCfg->authValue[pVDR->dataIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->authValue[pVDR->dataIndex].buffer, sCfg->authValue[pVDR->dataIndex].size );
			pArea->offset += sCfg->authValue[pVDR->dataIndex].size;
			pArea->headroom -= sCfg->authValue[pVDR->dataIndex].size;
		} else if (pVDR->fileType == CONFIG_DATA ) { //#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->data[pVDR->dataIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->data[pVDR->dataIndex].size ));
			pArea->offset += sizeof( sCfg->data[pVDR->dataIndex].size );
			pArea->headroom -= sizeof( sCfg->data[pVDR->dataIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->data[pVDR->dataIndex].buffer, sCfg->data[pVDR->dataIndex].size );
			pArea->offset += sCfg->data[pVDR->dataIndex].size;
			pArea->headroom -= sCfg->data[pVDR->dataIndex].size;
		} else if (pVDR->fileType == RAW_DATA ) {  //data is in a file
			//value is the offset in bytes from the beginning of the file to start reading the data; 
		} else {
			//Print(L"size: 0x%x\n", pVDR->size);
		
			u16Temp = ChangeEndiannessWord( pVDR->size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( pVDR->size ));
			pArea->offset += sizeof( pVDR->size );
			pArea->headroom -= sizeof( pVDR->size );
		}  
	//If ASCIIFILENAME or U16FILENAME, then buffer[ ] contains the filename that will provide the data.
	} else if( pVDR->bufType == ASCIIFILENAME ||  pVDR->bufType == U16FILENAME ) {
	
	
	//If PROMPT_FILE or PROMPT_DATA, then buffer[ ] contains prompt text to display (eg, Enter Password)
	} else if( pVDR->bufType == PROMPT_DATA ) {
		
	} else {
		Print(L"ERROR: Unrecognized buffer type in VDR_DATABUF\n");
	}
	
	
	return 0;
}

UINT8 PackT2T_DATA(T2P_CMDAREA *pArea, T2T_DATA *pDATA, T2P_CONFIG_FILE *sCfg)
{
	UINT16 			u16Temp = 0;
	
	//Print(L"pVDR->source: 0x%x\n", pDATA->source);
		
	if( pDATA->source == DATA_BUFFER ) { //1
		//Print(L"DATA_BUFFER\n");
		//Print(L"size: 0x%x\n", pVDR->size);
		//pack saltSize - UINT16B
		u16Temp = ChangeEndiannessWord( pDATA->size );
		CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( pDATA->size ));
		pArea->offset += sizeof( pDATA->size );
		pArea->headroom -= sizeof( pDATA->size );
	
		//pack the salt value
		//DumpHexValue (L"DATA_BUFFER:", (UINT8 *) &pDATA->buffer, pDATA->size);
		//Print(L"pArea->offset: %d\n", pArea->offset);
		CopyMem( &pArea->buf[pArea->offset], &pDATA->buffer, pDATA->size );
		pArea->offset += pDATA->size;
		pArea->headroom -= pDATA->size;
	} else if( pDATA->source == NULL_BUFFER ) { //0
	
		//Print(L"NULL_BUFFER\n");
		if (pDATA->provType == CONFIG_DIGEST ) { //#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->digest[pDATA->provIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->digest[pDATA->provIndex].size ));
			pArea->offset += sizeof( sCfg->digest[pDATA->provIndex].size );
			pArea->headroom -= sizeof( sCfg->digest[pDATA->provIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->digest[pDATA->provIndex].buffer, sCfg->digest[pDATA->provIndex].size );
			pArea->offset += sCfg->digest[pDATA->provIndex].size;
			pArea->headroom -= sCfg->digest[pDATA->provIndex].size;
		} else if (pDATA->provType == CONFIG_KEY ) { //#define	CONFIG_DIGEST		0xF1	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->key[pDATA->provIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->key[pDATA->provIndex].size ));
			pArea->offset += sizeof( sCfg->key[pDATA->provIndex].size );
			pArea->headroom -= sizeof( sCfg->key[pDATA->provIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->key[pDATA->provIndex].buffer, sCfg->key[pDATA->provIndex].size );
			pArea->offset += sCfg->key[pDATA->provIndex].size;
			pArea->headroom -= sCfg->key[pDATA->provIndex].size;
		} else if (pDATA->provType == CONFIG_AUTH ) { //#define	CONFIG_DIGEST		0xF2	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->authValue[pDATA->provIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->authValue[pDATA->provIndex].size ));
			pArea->offset += sizeof( sCfg->authValue[pDATA->provIndex].size );
			pArea->headroom -= sizeof( sCfg->authValue[pDATA->provIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->authValue[pDATA->provIndex].buffer, sCfg->authValue[pDATA->provIndex].size );
			pArea->offset += sCfg->authValue[pDATA->provIndex].size;
			pArea->headroom -= sCfg->authValue[pDATA->provIndex].size;
		} else if (pDATA->provType == CONFIG_DATA ) { //#define	CONFIG_DIGEST		0xF3	//retrieve data from Config.digest[dataIndex]
			//Pack2B( &pArea->buf[pArea->offset], &sCfg->digest[pVDR->dataIndex] );
			
			u16Temp = ChangeEndiannessWord( sCfg->data[pDATA->provIndex].size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( sCfg->data[pDATA->provIndex].size ));
			pArea->offset += sizeof( sCfg->data[pDATA->provIndex].size );
			pArea->headroom -= sizeof( sCfg->data[pDATA->provIndex].size );
			
			//DumpHexValue (L"DATA_BUFFER:", (UINT8 *)&sCfg->digest[pVDR->dataIndex].buffer, sCfg->digest[pVDR->dataIndex].size );
			//Print(L"pArea->offset: %d\n", pArea->offset);
			CopyMem( &pArea->buf[pArea->offset], &sCfg->data[pDATA->provIndex].buffer, sCfg->data[pDATA->provIndex].size );
			pArea->offset += sCfg->data[pDATA->provIndex].size;
			pArea->headroom -= sCfg->data[pDATA->provIndex].size;
		} else if (pDATA->provType == RAW_DATA ) {  //data is in a file
			//value is the offset in bytes from the beginning of the file to start reading the data; 
		}else {
			//Print(L"size: 0x%x\n", pVDR->size);
		
			u16Temp = ChangeEndiannessWord( pDATA->size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( pDATA->size ));
			pArea->offset += sizeof( pDATA->size );
			pArea->headroom -= sizeof( pDATA->size );
		}

	//If ASCIIFILENAME or U16FILENAME, then buffer[ ] contains the filename that will provide the data.
	} else if( pDATA->source == ASCIIFILENAME ||  pDATA->source == U16FILENAME ) {
	
	
	//If PROMPT_FILE or PROMPT_DATA, then buffer[ ] contains prompt text to display (eg, Enter Password)
	} else if( pDATA->source == PROMPT_DATA ) {
		
	} else {
			//Print(L"size: 0x%x\n", pVDR->size);
		
			u16Temp = ChangeEndiannessWord( pDATA->size );
			CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( pDATA->size ));
			pArea->offset += sizeof( pDATA->size );
			pArea->headroom -= sizeof( pDATA->size );
	}  
	
	
	return 0;
}

UINT8 PackFSR2B_DATABUF(T2P_CMDAREA *pArea, FSR2B_DATABUF *dataSource, T2P_CONFIG_FILE *sCfg)
{
	/*
	UINT16 			u16Temp = 0;
	
	Print(L"dataSource->size: %d\n", dataSource->size);
	u16Temp = ChangeEndiannessWord( dataSource->size );
	Print(L"pArea offset: %d\n", pArea->offset);
	CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( UINT16 ) );
	pArea->offset += sizeof( UINT16 );
	pArea->headroom -= sizeof( UINT16 );
	*/
	PackVDR(pArea, &dataSource->buffer, dataSource->size, sCfg );
	
	return 0;
}

UINT8 PackSymDef(T2P_CMDAREA *pArea, TPMT_SYM_DEF *pSymDef)
{
	UINT16		u16Temp = 0;
	
	if( pSymDef->algorithm == TPM_ALG_NULL ) {
		Print(L"TPM_ALG_NULL\n");
		Print(L"pSymDef->algorithm: 0x%x\n", pSymDef->algorithm);
		u16Temp = ChangeEndiannessWord( pSymDef->algorithm );
		CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( pSymDef->algorithm ) );
		pArea->offset += sizeof( pSymDef->algorithm );
		pArea->headroom -= sizeof( pSymDef->algorithm );
		
	} else if( pSymDef->algorithm == TPM_ALG_AES ) {
	
	//} else if( pSymDef->algorithm == TPM_ALG_SM4 ) {
	
	} else if( pSymDef->algorithm == TPM_ALG_XOR ) {
	
		
	} else {
		Print(L"ERROR: Unsuported symetric algorithm in TPMT_SYM_DEF\n");
	}
	return 0;
}

UINT8 PackAuthSession(T2P_AUTHAREA	*pArea, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber ) 
{
	UINT32 sessionHandle = 0;

	if ( sCfg->session[sessionNumber].tpmKey != TPM_RH_NULL ) {
		Print(L"tpmKey must be TPM_RH_NULL\n");
	 	return -1;
	}
	if ( sCfg->session[sessionNumber].bind != TPM_RH_NULL ) {
		Print(L"bind must be TPM_RH_NULL\n");
		return -1;
	}
	//Print(L"sessionNumber: %d\n", sessionNumber);
	//Print(L"sCfg->session[sessionNumber].sessionType: 0x%x\n", sCfg->session[sessionNumber].sessionType);
	if ( sCfg->session[sessionNumber].sessionType == TPM_SE_HMAC ) {
		Print(L"sessionType HMAC not supported\n");
		return -1;
	}
	
	//we always pack the session handle
	sessionHandle = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle );
	CopyMem( &pArea->buf[pArea->offset], &sessionHandle, sizeof( UINT32 ) );
	pArea->offset += sizeof( UINT32 );
	pArea->headroom -= sizeof( UINT32 );
	
	if ( sCfg->session[sessionNumber].nonceType == NONCE_EMPTY ) {
		UINT16 nonceSize = 0;
		
		//Print(L"Empty nonce\n");
		CopyMem( &pArea->buf[pArea->offset], &nonceSize, sizeof( UINT32 ) );
		pArea->offset += sizeof( UINT16 );
		pArea->headroom -= sizeof( UINT16 );
	} else if ( sCfg->session[sessionNumber].nonceType == NONCE_CONSTANT ) {
		UINT32			i = 0;
		UINT16 			u16Temp = 0;
		
		//Print(L"Constant nonce\n");
	
		u16Temp = ChangeEndiannessWord( sCfg->session[sessionNumber].nonceSize );
		CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( u16Temp ));
		pArea->offset += sizeof( u16Temp );
		pArea->headroom -= sizeof( u16Temp );
		//Print(L"nonce size: 0x%x\n",sCfg->session[sessionNumber].nonceSize);
		
		for( i = pArea->offset; i < (pArea->offset + sCfg->session[sessionNumber].nonceSize); i++ ) {																	// 20
			pArea->buf[i] = 0xA5;					
		}
		pArea->offset += sCfg->session[sessionNumber].nonceSize;
		pArea->headroom -= sCfg->session[sessionNumber].nonceSize;
	} else if ( sCfg->session[sessionNumber].nonceType == NONCE_RANDOM ) {
	
		//create a RandomNonce( size = sCfg->session[sessionNumber].nonceSize)
		//Pack2B(&AREA, RandomNonce)
		//Pack32(&AREA, sCfg->session[sessionNumber]. sessionAttributes
	}
	
	//Always pack the session attributes
	//Print(L"session->sessionAttr: 0x%x\n", sCfg->session[sessionNumber].sessionAttr );
	CopyMem( &pArea->buf[pArea->offset], &sCfg->session[sessionNumber].sessionAttr, sizeof( UINT8 ));
	pArea->offset += sizeof( UINT8 );
	pArea->headroom -= sizeof( UINT8 );
			
	if ( sCfg->session[sessionNumber].sessionType == TPM_SE_POLICY ) {
		UINT16 emptyAuthSize = 0;
		if ( sCfg->session[sessionNumber].authSource == EMPTY_AUTH ) {
			//Print(L"AuthSource: EMPTY_AUTH\n");
			CopyMem( &pArea->buf[pArea->offset], &emptyAuthSize, sizeof( UINT16 ));
			pArea->offset += sizeof( UINT16 );
			pArea->headroom -= sizeof( UINT16 );
		}
		if ( sCfg->session[sessionNumber].authSource == DEF_FILE_AUTH ) {
			//Print(L"AuthSource: DEF_FILE_AUTH\n");
			PackFSR2B_DATABUF( pArea, &sCfg->session[sessionNumber].authValue, sCfg);
		}
		if ( sCfg->session[sessionNumber].authSource == PLATFORMAUTH ) {
			//Print(L"AuthSource: PLATFORMAUTH\n");
			PackFSR2B_DATABUF( pArea, &sCfg->platformAuth, sCfg);
		}
		if ( sCfg->session[sessionNumber].authSource == OWNERAUTH ) {
			//Print(L"AuthSource: OWNERAUTH\n");
			PackFSR2B_DATABUF( pArea, &sCfg->ownerAuth, sCfg);
		}
		if ( sCfg->session[sessionNumber].authSource == SAVEDAUTH0 ) {
			//Print(L"AuthSource: SAVEDAUTH0\n");
			Pack2B( pArea, &sCfg->authValue[0]);
		}
		if ( sCfg->session[sessionNumber].authSource == SAVEDAUTH1 ) {
			//Print(L"AuthSource: SAVEDAUTH1\n");
			Pack2B( pArea, &sCfg->authValue[1]);
		}
		if ( sCfg->session[sessionNumber].authSource == SAVEDAUTH2 ) {
			//Print(L"AuthSource: SAVEDAUTH2\n");
			Pack2B( pArea, &sCfg->authValue[2]);
		}
		if ( sCfg->session[sessionNumber].authSource == SAVEDAUTH3 ) {
			//Print(L"AuthSource: SAVEDAUTH3\n");
			Pack2B( pArea, &sCfg->authValue[3]);
		}
		if ( sCfg->session[sessionNumber].authSource == SAVEDAUTH4 ) {
			//Print(L"AuthSource: SAVEDAUTH4\n");
			Pack2B( pArea, &sCfg->authValue[4]);
		}
	} else if ( sCfg->session[sessionNumber].sessionType == TPM_SE_PW ) {
	
		//double check that the session handle really is using the TCG built in password handle
		if ( sCfg->session[sessionNumber].sessionHandle == TPM_RS_PW ) { //UINT32 //40000009
	
			UINT16 authValueSize = ChangeEndiannessWord( sCfg->session[sessionNumber].authValue.size );
			
			//Print(L"authValueSize: 0x%x\n", authValueSize );
		
			CopyMem( &pArea->buf[pArea->offset], &authValueSize, sizeof( UINT16 ));
			pArea->offset += sizeof( UINT16 );
			pArea->headroom -= sizeof( UINT16 );

			if ( sCfg->session[sessionNumber].authValue.size > 0 ) {
				CopyMem( &pArea->buf[pArea->offset], &sCfg->session[sessionNumber].authValue.buffer.buffer, sCfg->session[sessionNumber].authValue.buffer.size );
				pArea->offset += sCfg->session[sessionNumber].authValue.size;
				pArea->headroom -= sCfg->session[sessionNumber].authValue.size;
			}
		}
	} else if ( sCfg->session[sessionNumber].sessionType == TPM_SE_TRIAL ) {
	
	}
	
	return 0;
}

UINT8 PackFSR2B_NV_PUBLIC(T2P_CMDAREA *pArea, FSR2B_NV_PUBLIC *publicInfo, T2P_CONFIG_FILE *sCfg)
{
	UINT16 			u16Temp = 0;
	
	//Print(L"publicInfo->size: %d\n", publicInfo->size);
	u16Temp = ChangeEndiannessWord( publicInfo->size );
	//Print(L"pArea offset: %d\n", pArea->offset);
	CopyMem( &pArea->buf[pArea->offset], &u16Temp, sizeof( UINT16 ) );
	pArea->offset += sizeof( UINT16 );
	pArea->headroom -= sizeof( UINT16 );
	
	PackNvPublic( pArea, &publicInfo->nvPublic, sCfg );
	
	return 0;
}

UINT8 PackNvPublic(T2P_CMDAREA *pArea, FSRS_NV_PUBLIC *nvPublic, T2P_CONFIG_FILE *sCfg) 
{
	UINT32	nvIndex;
	UINT16	nameAlg;
	UINT32	attributes;
	UINT16 	nvPublicSize;
	UINT16  dataSize;

	//pack nvIndex
	//Print(L"pArea->offset: %d\n", pArea->offset);
	//Print(L"iDef->nvPublic.nvIndex: %d\n", nvPublic->nvIndex);
	nvIndex = ChangeEndiannessDWord( nvPublic->nvIndex );
	CopyMem( &pArea->buf[pArea->offset], &nvIndex, sizeof( UINT32 ));
	pArea->offset += sizeof( UINT32 );
	pArea->headroom -= sizeof( UINT32 );
	
	//pack nameAlg
	//Print(L"pArea->offset: %d\n", pArea->offset);
	//Print(L"iDef->nvPublic.nameAlg: %d\n", nvPublic->nameAlg);
	nameAlg = ChangeEndiannessWord( nvPublic->nameAlg );
	CopyMem( &pArea->buf[pArea->offset], &nameAlg, sizeof( UINT16 ));
	pArea->offset += sizeof( UINT16 );
	pArea->headroom -= sizeof( UINT16 );
	
	//pack attributes
	//Print(L"pArea->offset: %d\n", pArea->offset);
	//Print(L"iDef->nvPublic.attributes: %d\n", nvPublic->attributes);
	CopyMem( &attributes, &nvPublic->attributes, sizeof(UINT32) );
	attributes = ChangeEndiannessDWord( attributes );
	CopyMem( &pArea->buf[pArea->offset], &attributes, sizeof( UINT32 ));
	pArea->offset += sizeof( UINT32 );
	pArea->headroom -= sizeof( UINT32 );
	
	//packvdr
	//Print(L"pArea->offset: %d\n", pArea->offset);
	PackFSR2B_DATABUF( pArea, &nvPublic->authPolicy, sCfg);
	
	//pack datsize
	//Print(L"iDef->nvPublic.dataSize: %d\n", nvPublic->dataSize);
	dataSize = ChangeEndiannessWord( nvPublic->dataSize );
	CopyMem( &pArea->buf[pArea->offset], &dataSize, sizeof( UINT16 ));
	pArea->offset += sizeof( UINT16 );
	pArea->headroom -= sizeof( UINT16 );

 return 0;
}

/*********************************************************************************************************/

UINT8 initFileHeader( FILE_HEADER *fileHeader) 
{

	EFI_STATUS      Status; 
	CHAR16			fileSig[9] = L"Tpm2Tool";
	
	ZeroMem(fileHeader->fileSig, 8);
	CopyMem(fileHeader->fileSig, fileSig, StrLen(fileSig) * 2); 
	fileHeader->fileSig[9] = CHAR_NULL;
	//Print( L"fileHeader->fileSig: %s \n", fileHeader->fileSig );	
	
	fileHeader->Tool_ID = 0;	
	//Print(L"Tool_ID: %d \n", fileHeader->Tool_ID );	
		
	fileHeader->ToolVersion = 2;	
	//Print(L"ToolVersion: %d \n", fileHeader->ToolVersion );	
	
	fileHeader->toolLevel = 0;	
	//Print(L"toolLevel: %d \n", fileHeader->toolLevel );	
	
	fileHeader->tpmFamily = 20;	
	//Print(L"tpmFamily: 0x%x \n", fileHeader->tpmFamily );	
	
	fileHeader->fileType = 2;	
	//Print(L"fileType: 0x%x \n", fileHeader->fileType );	
	
	fileHeader->reserved0 = 0;	
	//Print(L"reserved0: 0x%x \n", fileHeader->reserved0 );	
	
	fileHeader->StructVer = 0;	
	//Print(L"StructVer: 0x%x \n", fileHeader->StructVer );	
	
	fileHeader->StructFlags = 0;	
	//Print(L"StructFlags: 0x%x \n", fileHeader->StructFlags );	
	
	fileHeader->designLimits.maxDigestSize = 64;
	fileHeader->designLimits.maxNumPcrs = 24;
	fileHeader->designLimits.maxSoS = 0;
	fileHeader->designLimits.maxNumPcrAlg = 0;
	fileHeader->designLimits.maxNumBanks = 0;
	fileHeader->designLimits.reserved1 = 0;
	fileHeader->designLimits.reserved2 = 0;
	fileHeader->designLimits.reserved3 = 0;
	fileHeader->designLimits.maxKeySize = 256;
	fileHeader->designLimits.maxDataBufSize = 1024;
	fileHeader->designLimits.maxNumCmdCodes = 256;
	fileHeader->designLimits.reserved4 = 0;
	fileHeader->designLimits.reserved5 = 0;
	fileHeader->designLimits.reserved6 = 0;
	fileHeader->designLimits.reserved7 = 0;
}


/*********************************File Write functions****************************************************/

BOOLEAN update_FILE_HEADER( EFI_FILE_HANDLE *FileHandle, FILE_HEADER *header )  
{


	EFI_STATUS      Status; 
	
	//Print(L"//FILE_HEADER\n");
	Status = FileHandlePrintLine(*FileHandle, L"//FILE_HEADER");
	
	//Print(L"fileSig[8]: %s\n", header->fileSig);
	Status = FileHandlePrintLine(*FileHandle, L"fileSig[8]:%s", header->fileSig);
	
	//Print(L"Tool_ID: %d\n", header->Tool_ID);
	Status = FileHandlePrintLine(*FileHandle, L"Tool_ID: %d", header->Tool_ID);
	
	//Print(L"ToolVersion: %d\n", header->ToolVersion);
	Status = FileHandlePrintLine(*FileHandle, L"ToolVersion: %d", header->ToolVersion);
	
	//Print(L"toolLevel: 0x%x \n", header->toolLevel);
	Status = FileHandlePrintLine(*FileHandle, L"toolLevel: %x", header->toolLevel);
	
	//Print(L"tpmFamily: 0x%x \n", header->tpmFamily);
	Status = FileHandlePrintLine(*FileHandle, L"tpmFamily: %x", header->tpmFamily);
	
	//Print(L"fileType: %d \n", header->fileType);
	Status = FileHandlePrintLine(*FileHandle, L"fileType: %d", header->fileType);
	
	//Print(L"reserved0: %d \n", header->reserved0);
	Status = FileHandlePrintLine(*FileHandle, L"reserved0: %d", header->reserved0);
	
	//Print(L"StructVer: %d \n", header->StructVer);
	Status = FileHandlePrintLine(*FileHandle, L"StructVer: %d", header->StructVer);
	
	//Print(L"StructFlags: 0x%x \n", header->StructFlags);
	Status = FileHandlePrintLine(*FileHandle, L"StructFlags: %x", header->StructFlags);
	
	//T2T_ARCHLIMITS
	//Print(L"//T2T_ARCHLIMITS\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2T_ARCHLIMITS");
	
	//Print(L"maxDigestSize: %d \n", header->designLimits.maxDigestSize);
	Status = FileHandlePrintLine(*FileHandle, L"maxDigestSize: %d", header->designLimits.maxDigestSize);
	
	//Print(L"maxNumPcrs: %d \n", header->designLimits.maxNumPcrs);
	Status = FileHandlePrintLine(*FileHandle, L"maxNumPcrs: %d", header->designLimits.maxNumPcrs);
	
	//Print(L"maxSoS: 0x%x \n", header->designLimits.maxSoS);
	Status = FileHandlePrintLine(*FileHandle, L"maxSoS: %x", header->designLimits.maxSoS);
	
	//Print(L"maxNumPcrAlg: 0x%x \n", header->designLimits.maxNumPcrAlg);
	Status = FileHandlePrintLine(*FileHandle, L"maxNumPcrAlg: %x", header->designLimits.maxNumPcrAlg);
	
	//Print(L"maxNumBanks: %d \n", header->designLimits.maxNumBanks);
	Status = FileHandlePrintLine(*FileHandle, L"maxNumBanks: %d", header->designLimits.maxNumBanks);
	
	//Print(L"reserved1: %d \n", header->designLimits.reserved1);
	Status = FileHandlePrintLine(*FileHandle, L"reserved1: %d", header->designLimits.reserved1);
	
	//Print(L"reserved2: %d \n", header->designLimits.reserved2);
	Status = FileHandlePrintLine(*FileHandle, L"reserved2: %d", header->designLimits.reserved2);
	
	//Print(L"reserved3: %d \n", header->designLimits.reserved3);
	Status = FileHandlePrintLine(*FileHandle, L"reserved3: %d", header->designLimits.reserved3);
	
	//Print(L"maxKeySize: 0x%x \n", header->designLimits.maxKeySize);
	Status = FileHandlePrintLine(*FileHandle, L"maxKeySize: %x", header->designLimits.maxKeySize);
														
	//Print(L"maxDataBufSize: %d \n", header->designLimits.maxDataBufSize);
	Status = FileHandlePrintLine(*FileHandle, L"maxDataBufSize: %d", header->designLimits.maxDataBufSize);
	
	//Print(L"maxNumCmdCodes: %d \n", header->designLimits.maxNumCmdCodes);
	Status = FileHandlePrintLine(*FileHandle, L"maxNumCmdCodes: %d", header->designLimits.maxNumCmdCodes);
	
	//Print(L"reserved4: %d \n", header->designLimits.reserved4);
	Status = FileHandlePrintLine(*FileHandle, L"reserved4: %d", header->designLimits.reserved4);
	
	//Print(L"reserved5: %d \n", header->designLimits.reserved5);
	Status = FileHandlePrintLine(*FileHandle, L"reserved5: %d", header->designLimits.reserved5);
	
	//Print(L"reserved6: %d \n", header->designLimits.reserved6);
	Status = FileHandlePrintLine(*FileHandle, L"reserved6: %d", header->designLimits.reserved6);
	
	//Print(L"reserved7: %d \n", header->designLimits.reserved7);
	Status = FileHandlePrintLine(*FileHandle, L"reserved7: %d", header->designLimits.reserved7);
	
	return TRUE;
}

BOOLEAN update_FSR2B_KEY( EFI_FILE_HANDLE *FileHandle, FSR2B_KEY *fsr2bKey )
{
	
	EFI_STATUS      Status; 
	UINT32 			i = 0;
	
	//print buffer
	UINT32 			Size;
	UINT32 			bufferCounter = 0;
	CHAR16			*buffer;
	CHAR16			bufferText[9] = L"buffer: ";
	CHAR16			unicodeChar[3];
	
	//FSR2B_KEY
	//Print(L"//FSR2B_KEY\n");
	Status = FileHandlePrintLine(*FileHandle, L"//FSR2B_KEY");
	
	//Print(L"Size: 0x%x\n", fsr2bKey->size);
	Status = FileHandlePrintLine(*FileHandle, L"Size: 0x%Lx", fsr2bKey->size);
	
	//VDR_KEY
	//Print(L"//VDR_KEY\n");
	Status = FileHandlePrintLine(*FileHandle, L"//VDR_KEY");
	
	//Print(L"bufType: 0x%x\n", fsr2bKey->buffer.bufType);
	Status = FileHandlePrintLine(*FileHandle, L"bufType: 0x%Lx", fsr2bKey->buffer.bufType);
	
	//Print(L"fileType: %d\n", fsr2bKey->buffer.fileType);
	Status = FileHandlePrintLine(*FileHandle, L"fileType: %Ld", fsr2bKey->buffer.fileType);
	
	//Print(L"dataIndex: %d\n", fsr2bKey->buffer.dataIndex);
	Status = FileHandlePrintLine(*FileHandle, L"dataIndex: %Ld", fsr2bKey->buffer.dataIndex);
	
	//Print(L"reserved: %d\n", fsr2bKey->buffer.reserved);
	Status = FileHandlePrintLine(*FileHandle, L"reserved: %Ld", fsr2bKey->buffer.reserved);
	
	//Print(L"maxSize: %d\n", fsr2bKey->buffer.maxSize);
	Status = FileHandlePrintLine(*FileHandle, L"maxSize: %Ld", fsr2bKey->buffer.maxSize);
	
	//Print(L"size: 0x%x\n", fsr2bKey->buffer.size);
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", fsr2bKey->buffer.size);
	
	//print the buffer
	if( fsr2bKey->size > 0 ) {
		//allocate output buffer of the right size
		Size = (9 * sizeof(CHAR16)) + 2 * ( fsr2bKey->size * sizeof(CHAR16) );
		buffer = (CHAR16*)AllocateZeroPool( Size );
		
		//copy in the label
		StrnCpy(buffer, bufferText, StrLen(bufferText) );
		buffer[8] = CHAR_NULL;
		
		//format each byte of the auth value to UINT16 hex representation
		for ( bufferCounter = 0; bufferCounter < fsr2bKey->size; bufferCounter++ ) {
			UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%L02x", fsr2bKey->buffer.buffer[bufferCounter]);
			StrCat(buffer, unicodeChar);
		}
		//Print(L"%s\n", buffer);
		Status = FileHandleWriteLine(*FileHandle, buffer);
		FreePool(buffer);
	} else { 
		//Print(L"buffer: \n");
		Status = FileHandlePrintLine(*FileHandle, L"buffer: ");
	}
	
	return TRUE;
}

BOOLEAN update_FSR2B_AUTH( EFI_FILE_HANDLE *FileHandle, FSR2B_AUTH *fsr2bAuth )
{
	
	EFI_STATUS      Status; 
	UINT32 			i = 0;
	
	//print buffer
	UINT32 			Size;
	UINT32 			bufferCounter = 0;
	CHAR16			*buffer;
	CHAR16			bufferText[9] = L"buffer: ";
	CHAR16			unicodeChar[5];
	
	//FSR2B_AUTH
	//Print(L"//FSR2B_AUTH\n");
	Status = FileHandlePrintLine(*FileHandle, L"//FSR2B_AUTH");

	//Print(L"size: 0x%x\n", fsr2bAuth->size);
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", fsr2bAuth->size);
	
	//VDR_DIGEST
	//Print(L"//VDR_DIGEST\n");
	Status = FileHandlePrintLine(*FileHandle, L"//VDR_DIGEST");
	
	//Print(L"bufType: 0x%x\n", fsr2bAuth->buffer.bufType);
	Status = FileHandlePrintLine(*FileHandle, L"bufType: 0x%Lx", fsr2bAuth->buffer.bufType);
	
	//Print(L"fileType: %d\n", fsr2bAuth->buffer.fileType);
	Status = FileHandlePrintLine(*FileHandle, L"fileType: %Ld", fsr2bAuth->buffer.fileType);
	
	//Print(L"dataIndex: %d\n", fsr2bAuth->buffer.dataIndex);
	Status = FileHandlePrintLine(*FileHandle, L"dataIndex: %Ld", fsr2bAuth->buffer.dataIndex);
	
	//Print(L"reserved: %d\n", fsr2bAuth->buffer.reserved);
	Status = FileHandlePrintLine(*FileHandle, L"reserved: %Ld", fsr2bAuth->buffer.reserved);
	
	//Print(L"maxSize: %d\n", fsr2bAuth->buffer.maxSize);
	Status = FileHandlePrintLine(*FileHandle, L"maxSize: %Ld", fsr2bAuth->buffer.maxSize);
	
	//Print(L"size: 0x%x\n", fsr2bAuth->buffer.size);
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", fsr2bAuth->buffer.size);
	
	//print the buffer
	if( fsr2bAuth->size > 0 ) {
		//allocate output buffer of the right size
		Size = (9 * sizeof(CHAR16)) + 2 * ( fsr2bAuth->size * sizeof(CHAR16) );
		buffer = (CHAR16*)AllocateZeroPool( Size );
		
		//copy in the label
		StrnCpy(buffer, bufferText, StrLen(bufferText) );
		buffer[8] = CHAR_NULL;
		
		//format each byte of the auth value to UINT16 hex representation
		for ( bufferCounter = 0; bufferCounter < fsr2bAuth->size; bufferCounter++ ) {
			UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", fsr2bAuth->buffer.buffer[bufferCounter]);
			StrCat(buffer, unicodeChar);
		}
		//Print(L"%s\n", buffer);
		Status = FileHandleWriteLine(*FileHandle, buffer);
		FreePool(buffer);
	} else { 
		//Print(L"buffer: \n");
		Status = FileHandlePrintLine(*FileHandle, L"buffer: ");
	}
	
	return TRUE;
}

BOOLEAN update_T2P_SEQUENCE_CONTEXT( EFI_FILE_HANDLE *FileHandle, T2P_SEQUENCE_CONTEXT *squeContext )
{
	
	EFI_STATUS      Status; 
	UINT32 			i = 0;
	
	//print buffer
	UINT32 			Size;
	UINT32 			bufferCounter = 0;
	CHAR16			*buffer;
	CHAR16			bufferText[9] = L"buffer: ";
	CHAR16			unicodeChar[3];
	
	//T2P_SEQUENCE_CONTEXT
	//Print(L"//T2P_SEQUENCE_CONTEXT\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_SEQUENCE_CONTEXT");

	//Print(L"seqHandle: %x\n", squeContext->seqHandle);
	Status = FileHandlePrintLine(*FileHandle, L"seqHandle: %Lx", squeContext->seqHandle);
	
	//T2P_AUTH
	//Print(L"//T2P_AUTH\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_AUTH");
	
	//Print(L"size: %d\n", squeContext->authValue.size);
	Status = FileHandlePrintLine(*FileHandle, L"size: %Ld", squeContext->authValue.size);
	
	//print the buffer
	//allocate output buffer of the right size
	Size = (9 * sizeof(CHAR16)) + ( squeContext->authValue.size * sizeof(CHAR16) );
	buffer = (CHAR16*)AllocateZeroPool( Size );
	
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;
	
	//format each byte of the auth value to UINT16 hex representation
	for ( bufferCounter = 0; bufferCounter < squeContext->authValue.size; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%L02x", squeContext->authValue.buffer[bufferCounter]);
		StrCat(buffer, unicodeChar);
	}
	//Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);
		
	
	//Print(L"reserved: %d\n", squeContext->reserved);
	Status = FileHandlePrintLine(*FileHandle, L"reserved: %Ld", squeContext->reserved);	
	
	return TRUE;
}

BOOLEAN update_T2P_CONFIG_FILE( EFI_FILE_HANDLE *FileHandle, T2P_CONFIG_FILE *sCfg ) 
{


	EFI_STATUS      Status; 
	UINT32 			i = 0;
	CHAR16			TagBuffer[2];
	
	//print buffer
	UINT32 			Size;
	UINT32 			bufferCounter = 0;
	CHAR16			*buffer;
	CHAR16			bufferText[9] = L"buffer: ";
	CHAR16			unicodeChar[3];
	
	//buffer[8] = CHAR_NULL;
	
	//EFI_UNICODE_BYTE_ORDER_MARK
	//Status = FileHandlePrintLine(FileHandle, L"\0xfeff");
//#ifndef WIN32
	Size = sizeof(CHAR16);
	TagBuffer[0] = 0xfeff;
	TagBuffer[1] = CHAR_NULL;
	ShellWriteFile(*FileHandle, &Size, TagBuffer);
//#endif			
	update_FILE_HEADER(FileHandle, &sCfg->fHeader);
	
	
	//SCFG
	//Print(L"//SCFG\n");
	Status = FileHandlePrintLine(*FileHandle, L"//SCFG");
	
	update_FSR2B_AUTH(FileHandle, &sCfg->platformAuth);
	
	update_FSR2B_AUTH(FileHandle, &sCfg->ownerAuth);
	
	//T2P_AUTH 5
	//Print(L"//T2P_AUTH 5\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_AUTH 5");
	
	for ( i = 0; i < 5; i++ ) {
		//Print(L"size: %d\n", sCfg->authValue[i].size);
		Status = FileHandlePrintLine(*FileHandle, L"size: %Ld", sCfg->authValue[i].size);

		//allocate output buffer of the right size
		Size =  (9 * sizeof(CHAR16)) + 2 * ( sCfg->authValue[i].size * sizeof(CHAR16) );
		buffer = (CHAR16*)AllocateZeroPool( Size );
		
		//copy in the label
		StrnCpy(buffer, bufferText, StrLen(bufferText) );
		buffer[8] = CHAR_NULL;
		
		//format each byte of the auth value to UINT16 hex representation
		for ( bufferCounter = 0; bufferCounter < sCfg->authValue[i].size; bufferCounter++ ) {
			UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sCfg->authValue[i].buffer[bufferCounter]);
			StrCat(buffer, unicodeChar);
		}
		//Print(L"%s\n", buffer);
		Status = FileHandleWriteLine(*FileHandle, buffer);
		FreePool(buffer);
	}

	
	//TPM_HANDLE 10
	//Print(L"//TPM_HANDLE 10\n");
	Status = FileHandlePrintLine(*FileHandle, L"//TPM_HANDLE 10");
	
	for ( i = 0; i < 10; i++ ) {
		//Print(L"objHandle: %d\n", sCfg->objHandle[i]);
		Status = FileHandlePrintLine(*FileHandle, L"objHandle: 0x%Lx", (UINT32) sCfg->objHandle[i]);
	}
	
	//T2P_AUTH 8
	//Print(L"//T2P_AUTH 8\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_AUTH 8");
	
	for ( i = 0; i < 8; i++ ) {		
		//Print(L"size: 0x%x\n", sCfg->digest[i].size);
		Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sCfg->digest[i].size);

		//allocate output buffer of the right size
		Size =  (9 * sizeof(CHAR16)) + 2 * ( sCfg->digest[i].size * sizeof(CHAR16) );
		buffer = (CHAR16*)AllocateZeroPool( Size );
		
		//copy in the label
		StrnCpy(buffer, bufferText, StrLen(bufferText) );
		buffer[8] = CHAR_NULL;
		
		//format each byte of the auth value to UINT16 hex representation
		for ( bufferCounter = 0; bufferCounter < sCfg->digest[i].size; bufferCounter++ ) {
			UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sCfg->digest[i].buffer[bufferCounter]);
			StrCat(buffer, unicodeChar);
		}
		//Print(L"%s\n", buffer);
		Status = FileHandleWriteLine(*FileHandle, buffer);
		FreePool(buffer);
	}

	//T2P_SESSION_CONTEX
	for ( i = 0; i < 5; i++ ) {
		//Print(L"//T2P_SESSION_CONTEX\n");
		Status = FileHandlePrintLine(*FileHandle, L"//T2P_SESSION_CONTEX");
		
		//Print(L"sessionHandle: 0x%x\n", sCfg->session[i].sessionHandle);
		Status = FileHandlePrintLine(*FileHandle, L"sessionHandle: 0x%Lx", sCfg->session[i].sessionHandle);
		
		//T2P_TPM2B_100	
		//Print(L"//T2P_TPM2B_100\n");
		Status = FileHandlePrintLine(*FileHandle, L"//T2P_TPM2B_100");
		
		//Print(L"size: 0x%x\n", sCfg->session[i].lastNonceTpm.size);
		Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sCfg->session[i].lastNonceTpm.size);
		
		//print the buffer
		//allocate output buffer of the right size
		Size =  (9 * sizeof(CHAR16)) + 2 * ( sCfg->session[i].lastNonceTpm.size * sizeof(CHAR16) );
		buffer = (CHAR16*)AllocateZeroPool( Size );
		
		//copy in the label
		StrnCpy(buffer, bufferText, StrLen(bufferText) );
		buffer[8] = CHAR_NULL;
		
		//format each byte of the auth value to UINT16 hex representation
		for ( bufferCounter = 0; bufferCounter < sCfg->session[i].lastNonceTpm.size; bufferCounter++ ) {
			UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sCfg->session[i].lastNonceTpm.buffer[bufferCounter]);
			StrCat(buffer, unicodeChar);
		}
		//Print(L"%s\n", buffer);
		Status = FileHandleWriteLine(*FileHandle, buffer);
		FreePool(buffer);
		
		//SDEF
		//Print(L"//SDEF\n");
		Status = FileHandlePrintLine(*FileHandle, L"//SDEF");
		
		//Print(L"tpmKey: %x\n", sCfg->session[i].tpmKey);
		Status = FileHandlePrintLine(*FileHandle, L"tpmKey: 0x%Lx", sCfg->session[i].tpmKey);
		
		//Print(L"bind: %x\n", sCfg->session[i].bind);
		Status = FileHandlePrintLine(*FileHandle, L"bind: 0x%Lx", sCfg->session[i].bind);
		
		//Print(L"nonceSize: %d\n", sCfg->session[i].nonceSize);
		Status = FileHandlePrintLine(*FileHandle, L"nonceSize: %Ld", sCfg->session[i].nonceSize);
		
		//Print(L"nonceType: 0x%x\n", sCfg->session[i].nonceType);
		Status = FileHandlePrintLine(*FileHandle, L"nonceType: 0x%Lx", sCfg->session[i].nonceType);
		
		//FSR2B_KEY
		update_FSR2B_KEY(FileHandle, &sCfg->session[i].encryptedSalt);
		
		//SDEF_CONT
		//Print(L"//SDEF_CONT\n");
		Status = FileHandlePrintLine(*FileHandle, L"//SDEF_CONT");
		
		//Print(L"sessionType: 0x%x\n", sCfg->session[i].sessionType);
		Status = FileHandlePrintLine(*FileHandle, L"sessionType: 0x%Lx", sCfg->session[i].sessionType);
		
		//TPMT_SYM_DEF
		Status = FileHandlePrintLine(*FileHandle, L"//TPMT_SYM_DEF");
		//Print(L"//TPMT_SYM_DEF\n");
		
		//Print(L"algorithm: 0x%x\n", sCfg->session[i].symmetric.algorithm);
		Status = FileHandlePrintLine(*FileHandle, L"algorithm: 0x%Lx", sCfg->session[i].symmetric.algorithm);
		
		//Print(L"keyBits: 0x%x\n", sCfg->session[i].symmetric.keyBits);
		Status = FileHandlePrintLine(*FileHandle, L"keyBits: 0x%x", sCfg->session[i].symmetric.keyBits );	
		
		//Print(L"mode: 0x%x\n", sCfg->session[i].symmetric.mode);
		Status = FileHandlePrintLine(*FileHandle, L"mode: 0x%Lx", sCfg->session[i].symmetric.mode );	
		
		//Print(L"authHashAlg: 0x%x\n", sCfg->session[i].authHashAlg);
		Status = FileHandlePrintLine(*FileHandle, L"authHashAlg: 0x%Lx", sCfg->session[i].authHashAlg);
		
		//Print(L"sessionAttr: 0x%x\n", sCfg->session[i].sessionAttr);
		Status = FileHandlePrintLine(*FileHandle, L"sessionAttr: 0x%Lx%Lx%Lx%Lx%Lx%Lx%Lx", 
																sCfg->session[i].sessionAttr.continueSession,
																sCfg->session[i].sessionAttr.auditExclusive,
																sCfg->session[i].sessionAttr.auditReset,
																sCfg->session[i].sessionAttr.reserved3_4,
																sCfg->session[i].sessionAttr.decrypt,
																sCfg->session[i].sessionAttr.encrypt,
																sCfg->session[i].sessionAttr.audit );
		
		//Print(L"authSource: %d\n", sCfg->session[i].authSource);
		Status = FileHandlePrintLine(*FileHandle, L"authSource: %Ld", sCfg->session[i].authSource);
		
		update_FSR2B_AUTH(FileHandle, &sCfg->session[i].authValue);
		
		//SDEF_CONT
		//Print(L"//SDEF_CONT\n");
		Status = FileHandlePrintLine(*FileHandle, L"//SDEF_CONT");
		
		//Print(L"reserved: %d\n", sCfg->session[i].reserved);
		Status = FileHandlePrintLine(*FileHandle, L"reserved: %Ld", sCfg->session[i].reserved);
		
		//Print(L"reserved1: %d\n", sCfg->session[i].reserved1);
		Status = FileHandlePrintLine(*FileHandle, L"reserved1: %Ld", sCfg->session[i].reserved1);
		
		//Print(L"reserved2: %d\n", sCfg->session[i].reserved2);
		Status = FileHandlePrintLine(*FileHandle, L"reserved2: %Ld", sCfg->session[i].reserved2);		

	}
	
	//FSR2B_KEY
	for ( i = 0; i < 4; i++ ) {
		update_FSR2B_KEY(FileHandle, &sCfg->key[i]);
	}
	
	update_T2P_SEQUENCE_CONTEXT(FileHandle, &sCfg->hmacSequence);
	
	update_T2P_SEQUENCE_CONTEXT(FileHandle, &sCfg->hashSequence);

	//T2P_DATA                data[8];              //storage for 8 data elements
	for ( i = 0; i < 8; i++ ) {

		//T2P_DATA tag
		//Print(L"//T2P_DATA\n");
		Status = FileHandlePrintLine(*FileHandle, L"//T2P_DATA");
	
		//Print(L"sCfg->data.size: 0x%x \n", sCfg->data[i].size );	
		Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sCfg->data[i].size);
	
		//allocate output buffer of the right size
		Size =  (9 * sizeof(CHAR16)) + 2 * ( sCfg->data[i].size * sizeof(CHAR16) );
		buffer = (CHAR16*)AllocateZeroPool( Size );
		
		//copy in the label
		StrnCpy(buffer, bufferText, StrLen(bufferText) );
		buffer[8] = CHAR_NULL;

		for ( bufferCounter = 0; bufferCounter < sCfg->data[i].size; bufferCounter++ ) {
			UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sCfg->data[i].buffer[bufferCounter]);
			StrCat(buffer, unicodeChar);
		}
		//Print(L"%s\n", buffer);
		Status = FileHandleWriteLine(*FileHandle, buffer);
		FreePool(buffer);
	}

	//SCFG_CONT
	//Print(L"//SCFG_CONT\n");
	Status = FileHandlePrintLine(*FileHandle, L"//SCFG_CONT");
	
	//Print(L"reserved: %d\n", sCfg->reserved);
	Status = FileHandlePrintLine(*FileHandle, L"reserved: %Ld", sCfg->reserved);	
	
	//Print(L"reserved1: %d\n", sCfg->reserved1);
	Status = FileHandlePrintLine(*FileHandle, L"reserved1: %Ld", sCfg->reserved1);	
	
	//Print(L"reserved2: %d\n", sCfg->reserved2);
	Status = FileHandlePrintLine(*FileHandle, L"reserved2: %Ld", sCfg->reserved2);	
	
	//Print(L"reserved3: %d\n", sCfg->reserved3);
	Status = FileHandlePrintLine(*FileHandle, L"reserved3: %Ld", sCfg->reserved3);	
	
	//Print(L"Write Complete.\n");

	return TRUE;
}

BOOLEAN update_T2T_DATA_FILE( EFI_FILE_HANDLE *FileHandle, T2T_DATA_FILE *dataFile ) 
{
	EFI_STATUS      Status; 
	//print buffer
	UINT32 			Size;
	UINT32 			bufferCounter = 0;
	CHAR16			*buffer;
	CHAR16			bufferText[8] = L"Data: ";
	CHAR16			unicodeChar[3];
	
	CHAR16			TagBuffer[2];
	
	Size = sizeof(CHAR16);
	TagBuffer[0] = 0xfeff;
	TagBuffer[1] = CHAR_NULL;
	ShellWriteFile(*FileHandle, &Size, TagBuffer);
	
	update_FILE_HEADER(FileHandle, &dataFile->fHeader);
	
	Print(L"DataSize: %d\n", dataFile->DataSize);
	Status = FileHandlePrintLine(*FileHandle, L"DataSize: %Ld", dataFile->DataSize);

	//allocate output buffer of the right size
	Size = 8 + ( dataFile->DataSize * sizeof(CHAR16) );
	buffer = AllocateZeroPool( Size );
	
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;
	
	//format each byte of the auth value to UINT16 hex representation
	for ( bufferCounter = 0; bufferCounter < dataFile->DataSize; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%x", dataFile->Data);
		StrCat(buffer, unicodeChar);
	}
	Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);

	return TRUE;
}

BOOLEAN update_T2T_DIGEST_LIST_FILE( EFI_FILE_HANDLE *FileHandle, T2T_DIGEST_LIST_FILE *digestListFile ) 
{
	EFI_STATUS      Status; 
	//print buffer
	//UINT32 			Size;
	//UINT32 			bufferCounter = 0;
	//CHAR16			*buffer;
	//CHAR16			bufferText[8] = L"Data: ";
	//CHAR16			unicodeChar[3];
	UINT32 			i = 0;
	
	CHAR16			TagBuffer[2];
	UINT32 			Size;
//#ifndef WIN32
	Size = sizeof(CHAR16);
	TagBuffer[0] = 0xfeff;
	TagBuffer[1] = CHAR_NULL;
	ShellWriteFile(*FileHandle, &Size, TagBuffer);
//#endif
	update_FILE_HEADER(FileHandle, &digestListFile->fHeader);
	
	Print(L"//DLF\n");
	Status = FileHandlePrintLine(*FileHandle, L"//DLF");
	
	Print(L"alg: %d\n", digestListFile->alg);
	Status = FileHandlePrintLine(*FileHandle, L"alg: %Ld", digestListFile->alg);
	
	Print(L"count: %d\n", digestListFile->count);
	Status = FileHandlePrintLine(*FileHandle, L"count: %Ld", digestListFile->count);
	
	
	for ( i = 0; i < 24; i++ ) {
		update_FSR2B_AUTH(FileHandle, (FSR2B_AUTH *)&digestListFile->digest[i]);
	}
	
	return TRUE;
}

BOOLEAN update_T2P_SOBJ_FILE(EFI_FILE_HANDLE *FileHandle, T2T_SOBJ_FILE *sObj) 
{

	EFI_STATUS      Status; 
	UINT32 			i = 0;
	CHAR16			TagBuffer[2];
	
	//print buffer
	UINT32 			Size;
	UINT32 			bufferCounter = 0;
	CHAR16			*buffer;
	CHAR16			bufferText[9] = L"buffer: ";
	CHAR16			unicodeChar[3];

	//#ifndef WIN32
	Size = sizeof(CHAR16);
	TagBuffer[0] = 0xfeff;
	TagBuffer[1] = CHAR_NULL;
	ShellWriteFile(*FileHandle, &Size, TagBuffer);
	//#endif			
	update_FILE_HEADER(FileHandle, &sObj->fHeader);

	//TPM2B_PRIVATE 
	Print(L"//SOBJ\n");
	Status = FileHandlePrintLine(*FileHandle, L"//SOBJ");

	//TPM2B_PRIVATE 
	Print(L"//TPM2B_PRIVATE\n");
	Status = FileHandlePrintLine(*FileHandle, L"//TPM2B_PRIVATE");

	Print(L"//T2P_DATA\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_DATA");
	
	Print(L"sObj->encryptedPrivate.size: 0x%x \n", sObj->encryptedPrivate.size );	
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sObj->encryptedPrivate.size);
	
	//allocate output buffer of the right size
	Size =  (9 * sizeof(CHAR16)) + 2 * ( sObj->encryptedPrivate.size * sizeof(CHAR16) );
	buffer = (CHAR16*)AllocateZeroPool( Size );
		
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;

	for ( bufferCounter = 0; bufferCounter < sObj->encryptedPrivate.size; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sObj->encryptedPrivate.buffer[bufferCounter]);
		StrCat(buffer, unicodeChar);
	}
	Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);

	
	//TPM2B_PUBLIC 
	Print(L"//TPM2B_PUBLIC\n");
	Status = FileHandlePrintLine(*FileHandle, L"//TPM2B_PUBLIC");

	Print(L"//T2P_DATA\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_DATA");
	
	Print(L"sObj->keyPublic.size: 0x%x \n", sObj->keyPublic.size );	
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sObj->keyPublic.size);
	
	//allocate output buffer of the right size
	Size =  (9 * sizeof(CHAR16)) + 2 * ( sObj->keyPublic.size * sizeof(CHAR16) );
	buffer = (CHAR16*)AllocateZeroPool( Size );
		
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;

	for ( bufferCounter = 0; bufferCounter < sObj->keyPublic.size; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sObj->keyPublic.buffer[bufferCounter]);
		StrCat(buffer, unicodeChar);
	}
	Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);



	//TPM2B_CREATION_DATA
	Print(L"//TPM2B_CREATION_DATA\n");
	Status = FileHandlePrintLine(*FileHandle, L"//TPM2B_CREATION_DATA");

	Print(L"//T2P_DATA\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_DATA");
	
	Print(L"sObj->creationData.size: 0x%x \n", sObj->creationData.size );	
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sObj->creationData.size);
	
	//allocate output buffer of the right size
	Size =  (9 * sizeof(CHAR16)) + 2 * ( sObj->creationData.size * sizeof(CHAR16) );
	buffer = (CHAR16*)AllocateZeroPool( Size );
		
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;

	for ( bufferCounter = 0; bufferCounter < sObj->creationData.size; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sObj->creationData.buffer[bufferCounter]);
		StrCat(buffer, unicodeChar);
	}
	Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);


	
	//TPM2B_DIGEST
	Print(L"//TPM2B_DIGEST\n");
	Status = FileHandlePrintLine(*FileHandle, L"//TPM2B_DIGEST");

	Print(L"//T2P_DATA\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_DATA");
	
	Print(L"sObj->creationData.size: 0x%x \n", sObj->creationHash.size );	
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sObj->creationHash.size);
	
	//allocate output buffer of the right size
	Size =  (9 * sizeof(CHAR16)) + 2 * ( sObj->creationHash.size * sizeof(CHAR16) );
	buffer = (CHAR16*)AllocateZeroPool( Size );
		
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;

	for ( bufferCounter = 0; bufferCounter < sObj->creationHash.size; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sObj->creationHash.buffer[bufferCounter]);
		StrCat(buffer, unicodeChar);
	}
	Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);


	//TPMT_TK_CREATION 
	Print(L"//TPMT_TK_CREATION\n");
	Status = FileHandlePrintLine(*FileHandle, L"//TPMT_TK_CREATION");

	Print(L"//T2P_DATA\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_DATA");
	
	Print(L"sObj->creationData.size: 0x%x \n", sObj->creationTicket.size );	
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sObj->creationTicket.size);
	
	//allocate output buffer of the right size
	Size =  (9 * sizeof(CHAR16)) + 2 * ( sObj->creationTicket.size * sizeof(CHAR16) );
	buffer = (CHAR16*)AllocateZeroPool( Size );
		
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;

	for ( bufferCounter = 0; bufferCounter < sObj->creationTicket.size; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sObj->creationTicket.buffer[bufferCounter]);
		StrCat(buffer, unicodeChar);
	}
	Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);

	

	//TPM2B_NAME 
	Print(L"//TPM2B_NAME\n");
	Status = FileHandlePrintLine(*FileHandle, L"//TPM2B_NAME");

	Print(L"//T2P_DATA\n");
	Status = FileHandlePrintLine(*FileHandle, L"//T2P_DATA");
	
	Print(L"sObj->creationData.size: 0x%x \n", sObj->name.size );	
	Status = FileHandlePrintLine(*FileHandle, L"size: 0x%Lx", sObj->name.size);
	
	//allocate output buffer of the right size
	Size =  (9 * sizeof(CHAR16)) + 2 * ( sObj->name.size * sizeof(CHAR16) );
	buffer = (CHAR16*)AllocateZeroPool( Size );
		
	//copy in the label
	StrnCpy(buffer, bufferText, StrLen(bufferText) );
	buffer[8] = CHAR_NULL;

	for ( bufferCounter = 0; bufferCounter < sObj->name.size; bufferCounter++ ) {
		UnicodeSPrint(unicodeChar, sizeof(unicodeChar), L"%02x", sObj->name.buffer[bufferCounter]);
		StrCat(buffer, unicodeChar);
	}
	Print(L"%s\n", buffer);
	Status = FileHandleWriteLine(*FileHandle, buffer);
	FreePool(buffer);

	return 0;
}

/*********************************************************************************************************/

/*********************************TPM Helper Functions****************************************************/

UINT8 TPM_20_SendGenericCommand( T2P_CMD_SGL *pPackedCmd )
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM_2_0_RET_HEADER outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_RET_HEADER);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS) {
			
			Print(L"TPM2 Command: Return Code  - 0x%08x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}
	}
	else{
		
		errColor;
		Print(L"ERROR : Error in sending TPM2 command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_ExecuteCommand( T2P_CMD_SGL *pPackedCmd, UINT8* responseBuffer, UINT32 *responseSize, UINT16 *tag)
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM_2_0_RET_HEADER *outputHeader;
	UINT8 output[1024];
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	
	outputHeader = (TPM_2_0_RET_HEADER*)output;

	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)outputHeader;
	//OutputBuffers[0].Size = sizeof(TPM_2_0_RET_HEADER);
	OutputBuffers[0].Size = 1024;
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader->responseCode != TPM_RC_SUCCESS) {
			
			Print(L"TPM2 Command: Return Code  - 0x%08x\n", ChangeEndiannessDWord(outputHeader->responseCode));
			
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader->responseCode) );
			
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			*tag = ChangeEndiannessWord(outputHeader->tag);
			*responseSize = ChangeEndiannessDWord(outputHeader->responseSize);
			CopyMem(responseBuffer, output, ChangeEndiannessDWord(outputHeader->responseSize) );
		}
	}
	else{
		
		errColor;
		Print(L"ERROR : Error in sending TPM2 command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

/*
// Table 60 -- TPMU_HA from outputUnionDef <I/O,S>
typedef union {
    BYTE  sha1[SHA1_DIGEST_SIZE];  				// 20 bytes
    BYTE  sha256[SHA256_DIGEST_SIZE];  
    BYTE  sm3_256[SM3_256_DIGEST_SIZE];  
    BYTE  sha384[SHA384_DIGEST_SIZE];  
    BYTE  sha512[SHA512_DIGEST_SIZE];  
    BYTE  whirlpool[WHIRLPOOL512_DIGEST_SIZE];  
} TPMU_HA ;

// Table 71 -- TPMU_NAME from outputUnionDef <S>
typedef union {
    TPMU_HA  digest;  	// 20 bytes sha1
    TPM_HANDLE  handle; // UINT32

} TPMU_NAME ;			// 24 bytes total

// Table 72 -- TPM2B_NAME from outputStructDef <I/O>
typedef struct {
    UINT16    size;						// 2 bytes
    BYTE      name[sizeof(TPMU_NAME)];	// 24 bytes sha1
} TPM2B_NAME;							// 26 bytes total

typedef TPM_HANDLE TPMI_RH_NV_INDEX;		// 24 bytes

typedef UINT16 TPM_ALG_ID;

typedef TPM_ALG_ID TPMI_ALG_HASH;			// 2 bytes

// Table 63 -- TPM2B_DIGEST from outputStructDef <I/O>
typedef struct {
    UINT16    size;							// 2 bytes
    BYTE      buffer[sizeof(TPMU_HA)];		// 20 bytes sha1
} TPM2B_DIGEST;								// 22 bytes total

// Table 183 -- TPMS_NV_PUBLIC from outputStructDef <I/O>
typedef struct {
    TPMI_RH_NV_INDEX    nvIndex;		// 4 bytes
    TPMI_ALG_HASH       nameAlg;		// 2 bytes
    TPMA_NV             attributes;		// 4 bytes
    TPM2B_DIGEST        authPolicy;		// 22 bytes total
    UINT16              dataSize;		// 2 bytes
} TPMS_NV_PUBLIC;						// 34 bytes total

// Table 184 -- TPM2B_NV_PUBLIC from outputStructDef <I/O>
typedef struct {
    UINT16            size;		// 2 bytes
    TPMS_NV_PUBLIC    nvPublic;	// 34 bytes
} TPM2B_NV_PUBLIC;				// 36 bytes total

typedef struct {
  TPM_ST tag;			//UINT16
  UINT32 responseSize;
  UINT32 responseCode;
//
// NOTE: other output data consists of the following fields.  But it can't be
// specified here because some structures can vary in size.
//
//  TPM2B_NV_PUBLIC nvPublic;	// 36 bytes sha1
//  TPM2B_NAME nvName;			// 26 bytes sha1
//
} TPM20_NVReadPublic_Out;		// 62 bytes total

*/
UINT8 TPM_20_NV_ReadPublic(UINT32 index, UINT32 dataSize, FSR2B_NV_PUBLIC *publicInfo, TPM2B_NAME *name, BOOLEAN verbose)
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_NVReadPublic_In inputHeader;
	UINT8 *outputBuffer;
	TPM20_NVReadPublic_Out *pOutputStructure;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	TPM2B_NV_PUBLIC *BnvPublic;	// 56 bytes sha1
	UINT8	*pDataSize = 0;
	

	outputBuffer = (UINT8*)AllocateZeroPool(1024);
	//pOutputStructure = outputBuffer;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord( sizeof(TPM20_NVReadPublic_In) );
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_NV_ReadPublic);
	inputHeader.nvIndex = ChangeEndiannessDWord(index);
	
	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_NVReadPublic_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)outputBuffer;
	OutputBuffers[0].Size = dataSize;
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		UINT32 attributes = 0;
		
		//TPM2B_DIGEST  *authPolicy;
		
	
		pOutputStructure = (TPM20_NVReadPublic_Out*) outputBuffer;		
		
		if (pOutputStructure->responseCode != TPM_RC_SUCCESS) {	
			Print(L"TPM_20_NV_ReadPublic: Return Code  - 0x%x\n", pOutputStructure->responseCode);
			decodeTpm20ErrorCode( ChangeEndiannessDWord(pOutputStructure->responseCode) );
			return TCG_GENERAL_ERROR;
		}else {
			UINT16 *tempDataSize;
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			DumpHexValue (L"Read Public Data:", (UINT8 *) outputBuffer,  ChangeEndiannessDWord(pOutputStructure->responseSize));

			publicInfo->nvPublic.nvIndex = ChangeEndiannessDWord(pOutputStructure->nvIndex);
			publicInfo->nvPublic.nameAlg = ChangeEndiannessWord(pOutputStructure->nameAlg);
			CopyMem(&attributes, &pOutputStructure->attributes, sizeof(UINT32) );
			attributes = ChangeEndiannessDWord(attributes);
			CopyMem( &publicInfo->nvPublic.attributes, &attributes, sizeof(UINT32) );
			publicInfo->nvPublic.authPolicy.size = ChangeEndiannessWord(pOutputStructure->authPolicySize);
			publicInfo->nvPublic.authPolicy.buffer.size = ChangeEndiannessWord(pOutputStructure->authPolicySize);
			if ( publicInfo->nvPublic.authPolicy.size > 0 ) {
				CopyMem( &publicInfo->nvPublic.authPolicy.buffer.buffer, &pOutputStructure->authPolicy, publicInfo->nvPublic.authPolicy.buffer.size );
				pDataSize = (UINT8*)&pOutputStructure->authPolicy;
				pDataSize += publicInfo->nvPublic.authPolicy.buffer.size;
			} else {
				pDataSize = &pOutputStructure->authPolicySize;
				pDataSize += 2;
			}
			tempDataSize = ((UINT16*)pDataSize);
			publicInfo->nvPublic.dataSize  = ChangeEndiannessWord( *tempDataSize );

			//step past datasize to the name struct
			pDataSize += 2;
			tempDataSize = ((UINT16*)pDataSize);
			name->size =  ChangeEndiannessWord( (UINT16)*tempDataSize );
			//name->t.name = (UINT8*)AllocateZeroPool(*tempDataSize);
			pDataSize += 2;	
			CopyMem( &name->name, pDataSize, name->size );

			if(verbose == TRUE){
				Print(L"  NvIndex:          0x%08x\n", publicInfo->nvPublic.nvIndex);
				Print(L"  NameAlg:          0x%04x\n", publicInfo->nvPublic.nameAlg);
				Print(L"  Attributes:       0x%08x\n", publicInfo->nvPublic.attributes);
				Print(L"  AuthPolicy Size:  0x%04x\n", publicInfo->nvPublic.authPolicy.size);
				DumpHexValue (L"  AuthPolicy Digest:", (UINT8 *) &publicInfo->nvPublic.authPolicy.buffer.buffer, publicInfo->nvPublic.authPolicy.buffer.size);
				Print(L"  DataSize:         0x%04x\n", publicInfo->nvPublic.dataSize);

				Print(L"  Name Size:  0x%04x\n", name->size);
				DumpHexValue (L"  Name:", (UINT8 *) &name->name, name->size);
			}
		}
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_ReadPublic(UINT32 objectHandle, TPM2B_PUBLIC *publicInfo, TPM2B_NAME *name, TPM2B_NAME *qualifiedName, BOOLEAN verbose)
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_ReadPublic_In inputHeader;
	UINT8 *outputBuffer;
	TPM20_ReadPublic_Out_ *pOutputStructure;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	TPM2B_PUBLIC *poutPublic;	// 56 bytes sha1
	UINT8	*pData = 0;
	UINT16 *tempDataSize =  NULL;

	outputBuffer = (UINT8*)AllocateZeroPool(1024);
	//pOutputStructure = outputBuffer;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord( sizeof(TPM20_ReadPublic_In) );
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_ReadPublic);
	inputHeader.objectHandle = ChangeEndiannessDWord(objectHandle);
	
	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_ReadPublic_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)outputBuffer;
	OutputBuffers[0].Size = 1024;
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		pOutputStructure = (TPM20_ReadPublic_Out_*) outputBuffer;		
		
		if (pOutputStructure->responseCode != TPM_RC_SUCCESS) {	
			Print(L"TPM_20_ReadPublic: Return Code  - 0x%x\n", pOutputStructure->responseCode);
			decodeTpm20ErrorCode( ChangeEndiannessDWord(pOutputStructure->responseCode) );
			return TCG_GENERAL_ERROR;
		}else {
			UINT16	outPublicDataSize = 0;
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			DumpHexValue (L"Read Public Data:", (UINT8 *) outputBuffer,  ChangeEndiannessDWord(pOutputStructure->responseSize));

			publicInfo->size = ChangeEndiannessWord(pOutputStructure->outPublic.size);
			publicInfo->publicArea.type = ChangeEndiannessWord(pOutputStructure->outPublic.publicArea.type);
			publicInfo->publicArea.nameAlg = ChangeEndiannessWord(pOutputStructure->outPublic.publicArea.nameAlg);
			CopyMem(&publicInfo->publicArea.objectAttributes, &pOutputStructure->outPublic.publicArea.objectAttributes, sizeof(UINT32) );
			
			publicInfo->publicArea.authPolicy.size = ChangeEndiannessWord( pOutputStructure->outPublic.publicArea.authPolicy.size );
			CopyMem(&publicInfo->publicArea.authPolicy.buffer, &pOutputStructure->outPublic.publicArea.authPolicy.buffer, publicInfo->publicArea.authPolicy.size );

			outPublicDataSize = ChangeEndiannessWord( pOutputStructure->outPublic.size );
			//pData = (UINT8*)&pOutputStructure->outPublic.buffer;
			pData = (UINT8*)&pOutputStructure->outPublic;
			pData += outPublicDataSize;

			//skip parameters, skip unique

			//copy the name info
			tempDataSize = ((UINT16*)pData);
			name->size =  ChangeEndiannessWord( (UINT16)*tempDataSize );
			//name->t.name = (UINT8*)AllocateZeroPool(*tempDataSize);
			pData += 2;	
			CopyMem( &name->name, pData, name->size );
			pData += name->size;

			//copy the qualified name
			tempDataSize = ((UINT16*)pData);
			qualifiedName->size = ChangeEndiannessWord( (UINT16)*tempDataSize );
			//qualifiedName->t.name = (UINT8*)AllocateZeroPool(*tempDataSize);
			pData += 2;	
			CopyMem( &qualifiedName->name, pData, qualifiedName->size );

			if(verbose == TRUE){
				Print(L"  publicInfo->size:          0x%08x\n", publicInfo->size);
				Print(L"  publicArea.type:          0x%04x\n", publicInfo->publicArea.type);
				Print(L"  publicArea.nameAlg:       0x%08x\n", publicInfo->publicArea.nameAlg);
				Print(L"  AuthPolicy Size:  0x%04x\n", publicInfo->publicArea.authPolicy.size);
				DumpHexValue (L"  AuthPolicy:", (UINT8 *) &publicInfo->publicArea.authPolicy.buffer, publicInfo->publicArea.authPolicy.size);

				Print(L"  Name Size:  0x%04x\n", name->size);
				DumpHexValue (L"  Name:", (UINT8 *) &name->name, name->size);

				Print(L"  Qualified Name Size:  0x%04x\n", qualifiedName->size);
				DumpHexValue (L"  Qualified Name:", (UINT8 *) &qualifiedName->name, qualifiedName->size);
			}
		}
	}
	
	return u8CmdStatus;
}

BOOLEAN packNvReadVerifyDef(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						FSR2B_NV_PUBLIC *nvPublic0, FSR2B_AUTH *auth )
{

	UINT32	authSessionSize;
	UINT16	offset;
	UINT16	dataSize;
	UINT32	sessionHandle;
	UINT16	nonceSize = 0;
	UINT8	sessionAttributes = 0;
	UINT16	authValueSize;
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_NV_Read);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( nvPublic0->nvPublic.nvIndex ); //session handle from config file
	cmdHandles->handle[1] = ChangeEndiannessDWord( nvPublic0->nvPublic.nvIndex ); //session handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//Print(L"sCfg->session[sessionNumber].sessionHandle: 0x%x\n", sCfg->session[sessionNumber].sessionHandle);
	cmdAuthArea->offset = 0;
	cmdAuthArea->offset = sizeof(UINT32);
	//PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//we always pack the session handle
	sessionHandle = ChangeEndiannessDWord( TPM_RS_PW );
	CopyMem( &cmdAuthArea->buf[cmdAuthArea->offset], &sessionHandle, sizeof( UINT32 ) );
	cmdAuthArea->offset += sizeof( UINT32 );
	cmdAuthArea->headroom -= sizeof( UINT32 );

	//Print(L"Empty nonce\n");
	CopyMem( &cmdAuthArea->buf[cmdAuthArea->offset], &nonceSize, sizeof( UINT32 ) );
	cmdAuthArea->offset += sizeof( UINT16 );
	cmdAuthArea->headroom -= sizeof( UINT16 );

	//Always pack the session attributes
	//Print(L"session->sessionAttr: 0x%x\n", sessionAttributes );
	CopyMem( &cmdAuthArea->buf[cmdAuthArea->offset], &sessionAttributes, sizeof( UINT8 ));
	cmdAuthArea->offset += sizeof( UINT8 );
	cmdAuthArea->headroom -= sizeof( UINT8 );

	authValueSize = ChangeEndiannessWord( auth->buffer.size );
	//Print(L"authValueSize: 0x%x\n", authValueSize );
	CopyMem( &cmdAuthArea->buf[cmdAuthArea->offset], &authValueSize, sizeof( UINT16 ));
	cmdAuthArea->offset += sizeof( UINT16 );
	cmdAuthArea->headroom -= sizeof( UINT16 );

	if ( auth->buffer.size > 0 ) {
		CopyMem( &cmdAuthArea->buf[cmdAuthArea->offset], &auth->buffer.buffer, auth->buffer.size );
		cmdAuthArea->offset += auth->buffer.size;
		cmdAuthArea->headroom -= auth->buffer.size;
	}

	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//pack the datasize
	//Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
	dataSize = ChangeEndiannessWord( 0 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &dataSize, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);

	//pack the offset
	//Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
	offset = ChangeEndiannessWord( 0 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &offset, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);
	
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

UINT8 TPM_20_NV_Verify_Def(FSR2B_NV_PUBLIC *nvPublic0, FSR2B_NV_PUBLIC *nvPublic1, UINT32 verify, FSR2B_AUTH *auth, UINT32 attributeMask )
{
	UINT8 compare = 0;
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;

	if (nvPublic0->nvPublic.nvIndex != nvPublic1->nvPublic.nvIndex ) {
		Print(L"SDEF nvIndex 0x%x != NV Def nvIndex 0x%x\n", nvPublic0->nvPublic.nvIndex, nvPublic1->nvPublic.nvIndex);
		compare = ERROR_INVALID_INDEX;
	}

	//Print(L"Verify: 0x%x\n", verify);

	//Verify Auth value
	if ( (verify & 0x1) != 0 ) {

		if (nvPublic1->nvPublic.attributes.TPMA_NV_WRITTEN == 0) {
			Print(L"Index not written - cannot check auth value\n");
			compare = 0;
		} else {

			packNvReadVerifyDef(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, nvPublic0, auth );
			if ( TPM_20_SendGenericCommand( &packedCmd ) != 0 ) {
				//Print(L"SDEF nameAlg 0x%x != NV Def nameAlg 0x%x\n", nvPublic0->nvPublic.nameAlg, nvPublic1->nvPublic.nameAlg);
				compare = ERROR_AUTH_VALUE;
			} else {
				Print(L"Index auth value validated\n");
			}
		}
	}

	//Check Name Algorithm
	if ( (verify & 0x2) != 0 ) {
		if (nvPublic0->nvPublic.nameAlg != nvPublic1->nvPublic.nameAlg ) {
			Print(L"SDEF nameAlg 0x%x != NV Def nameAlg 0x%x\n", nvPublic0->nvPublic.nameAlg, nvPublic1->nvPublic.nameAlg);
			compare = ERROR_NAME_ALG;
		}
	}

	//Verify Auth policy digest
	if ( (verify & 0x4) != 0 ) {
		if ( CompareMem( &nvPublic0->nvPublic.authPolicy.buffer.buffer, &nvPublic1->nvPublic.authPolicy.buffer.buffer, nvPublic0->nvPublic.authPolicy.buffer.size) != 0 ) {
			DumpHexValue (L"  AuthPolicy Digest iDef:", (UINT8 *) &nvPublic0->nvPublic.authPolicy.buffer.buffer, nvPublic0->nvPublic.authPolicy.buffer.size);
			DumpHexValue (L"  AuthPolicy Digest index:", (UINT8 *) &nvPublic1->nvPublic.authPolicy.buffer.buffer, nvPublic1->nvPublic.authPolicy.buffer.size);
			compare = ERROR_AUTH_POLICY;
		}
	}

	//Verify Datasize
	if ( (verify & 0x8) != 0 ) {
		if (nvPublic0->nvPublic.dataSize != nvPublic1->nvPublic.dataSize ) {
			Print(L"SDEF dataSize 0x%x != NV Def dataSize 0x%x\n", nvPublic0->nvPublic.dataSize, nvPublic1->nvPublic.dataSize);
			compare = ERROR_DATA_SIZE;
		}
	}

	//Verify Index attributes
	if ( (verify & 0x10) != 0 ) {
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_PPWRITE) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_PPWRITE) ) {
			Print(L"SDEF attribute: TPMA_NV_PPWRITE 0x%x != NV Def attribute: TPMA_NV_PPWRITE 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_PPWRITE, nvPublic1->nvPublic.attributes.TPMA_NV_PPWRITE);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_OWNERWRITE) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_OWNERWRITE) ) {
			Print(L"SDEF attribute: TPMA_NV_OWNERWRITE 0x%x != NV Def attribute: TPMA_NV_OWNERWRITE 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_OWNERWRITE, nvPublic1->nvPublic.attributes.TPMA_NV_OWNERWRITE);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_AUTHWRITE) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_AUTHWRITE) ) {
			Print(L"SDEF attribute: TPMA_NV_AUTHWRITE 0x%x != NV Def attribute: TPMA_NV_AUTHWRITE 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_AUTHWRITE, nvPublic1->nvPublic.attributes.TPMA_NV_AUTHWRITE);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_POLICYWRITE) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_POLICYWRITE) ) {
			Print(L"SDEF attribute: TPMA_NV_POLICYWRITE 0x%x != NV Def attribute: TPMA_NV_POLICYWRITE 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_POLICYWRITE, nvPublic1->nvPublic.attributes.TPMA_NV_POLICYWRITE);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_COUNTER) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_COUNTER) ) {
			Print(L"SDEF attribute: TPMA_NV_COUNTER 0x%x != NV Def attribute: TPMA_NV_COUNTER 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_COUNTER, nvPublic1->nvPublic.attributes.TPMA_NV_COUNTER);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_BITS) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_BITS) ) {
			Print(L"SDEF attribute: TPMA_NV_BITS 0x%x != NV Def attribute: TPMA_NV_BITS 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_BITS, nvPublic1->nvPublic.attributes.TPMA_NV_BITS);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_EXTEND) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_EXTEND) ) {
			Print(L"SDEF attribute: TPMA_NV_EXTEND 0x%x != NV Def attribute: TPMA_NV_EXTEND 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_EXTEND, nvPublic1->nvPublic.attributes.TPMA_NV_EXTEND);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_WRITELOCKED) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_WRITELOCKED) ) {
			Print(L"SDEF attribute: TPMA_NV_WRITELOCKED 0x%x != NV Def attribute: TPMA_NV_WRITELOCKED 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_WRITELOCKED, nvPublic1->nvPublic.attributes.TPMA_NV_WRITELOCKED);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_WRITEALL) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_WRITEALL) ) {
			Print(L"SDEF attribute: TPMA_NV_WRITEALL 0x%x != NV Def attribute: TPMA_NV_WRITEALL 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_WRITEALL, nvPublic1->nvPublic.attributes.TPMA_NV_WRITEALL);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_WRITEDEFINE) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_WRITEDEFINE) ) {
			Print(L"SDEF attribute: TPMA_NV_WRITEDEFINE 0x%x != NV Def attribute: TPMA_NV_WRITEDEFINE 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_WRITEDEFINE, nvPublic1->nvPublic.attributes.TPMA_NV_WRITEDEFINE);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_WRITE_STCLEAR) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_WRITE_STCLEAR) ) {
			Print(L"SDEF attribute: TPMA_NV_WRITE_STCLEAR 0x%x != NV Def attribute: TPMA_NV_WRITE_STCLEAR 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_WRITE_STCLEAR, nvPublic1->nvPublic.attributes.TPMA_NV_WRITE_STCLEAR);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_GLOBALLOCK) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_GLOBALLOCK) ) {
			Print(L"SDEF attribute: TPMA_NV_GLOBALLOCK 0x%x != NV Def attribute: TPMA_NV_GLOBALLOCK 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_GLOBALLOCK, nvPublic1->nvPublic.attributes.TPMA_NV_GLOBALLOCK);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_PPREAD) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_PPREAD) ) {
			Print(L"SDEF attribute: TPMA_NV_PPREAD 0x%x != NV Def attribute: TPMA_NV_PPREAD 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_PPREAD, nvPublic1->nvPublic.attributes.TPMA_NV_PPREAD);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_OWNERREAD) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_OWNERREAD) ) {
			Print(L"SDEF attribute: TPMA_NV_OWNERREAD 0x%x != NV Def attribute: TPMA_NV_OWNERREAD 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_OWNERREAD, nvPublic1->nvPublic.attributes.TPMA_NV_OWNERREAD);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_AUTHREAD) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_AUTHREAD) ) {
			Print(L"SDEF attribute: TPMA_NV_AUTHREAD 0x%x != NV Def attribute: TPMA_NV_AUTHREAD 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_AUTHREAD, nvPublic1->nvPublic.attributes.TPMA_NV_AUTHREAD);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_POLICYREAD) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_POLICYREAD) ) {
			Print(L"SDEF attribute: TPMA_NV_POLICYREAD 0x%x != NV Def attribute: TPMA_NV_POLICYREAD 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_POLICYREAD, nvPublic1->nvPublic.attributes.TPMA_NV_POLICYREAD);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_NO_DA) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_NO_DA) ) {
			Print(L"SDEF attribute: TPMA_NV_NO_DA 0x%x != NV Def attribute: TPMA_NV_NO_DA 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_NO_DA, nvPublic1->nvPublic.attributes.TPMA_NV_NO_DA);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_ORDERLY) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_ORDERLY) ) {
			Print(L"SDEF attribute: TPMA_NV_ORDERLY 0x%x != NV Def attribute: TPMA_NV_ORDERLY 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_ORDERLY, nvPublic1->nvPublic.attributes.TPMA_NV_ORDERLY);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_CLEAR_STCLEAR) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_CLEAR_STCLEAR) ) {
			Print(L"SDEF attribute: TPMA_NV_CLEAR_STCLEAR 0x%x != NV Def attribute: TPMA_NV_CLEAR_STCLEAR 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_CLEAR_STCLEAR, nvPublic1->nvPublic.attributes.TPMA_NV_CLEAR_STCLEAR);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_READLOCKED) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_READLOCKED) ) {
			Print(L"SDEF attribute: TPMA_NV_READLOCKED 0x%x != NV Def attribute: TPMA_NV_READLOCKED 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_READLOCKED, nvPublic1->nvPublic.attributes.TPMA_NV_READLOCKED);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_PLATFORMCREATE) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_PLATFORMCREATE) ) {
			Print(L"SDEF attribute: TPMA_NV_PLATFORMCREATE 0x%x != NV Def attribute: TPMA_NV_PLATFORMCREATE 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_PLATFORMCREATE, nvPublic1->nvPublic.attributes.TPMA_NV_PLATFORMCREATE);
			compare = ERROR_ATTRIBUTES;
		}
		if ( (attributeMask & nvPublic0->nvPublic.attributes.TPMA_NV_READ_STCLEAR) != (attributeMask & nvPublic1->nvPublic.attributes.TPMA_NV_READ_STCLEAR) ) {
			Print(L"SDEF attribute: TPMA_NV_READ_STCLEAR 0x%x != NV Def attribute: TPMA_NV_READ_STCLEAR 0x%x\n", 
			nvPublic0->nvPublic.attributes.TPMA_NV_READ_STCLEAR, nvPublic1->nvPublic.attributes.TPMA_NV_READ_STCLEAR);
			compare = ERROR_ATTRIBUTES;
		}
	}

	return compare;
}

/*
// Table 63 -- TPM2B_DIGEST from outputStructDef <I/O>
typedef struct {
    UINT16    size;
    BYTE      buffer[sizeof(TPMU_HA)];
} TPM2B_DIGEST;
*/
//typedef TPM2B_DIGEST    TPM2B_NONCE;
/*
// Table 26 -- TPMA_SESSION from outputBitDef <I/O>
typedef struct {
    unsigned int continueSession : 1;
    unsigned int auditExclusive  : 1;
    unsigned int auditReset      : 1;
    unsigned int reserved4       : 2;
    unsigned int encrypted       : 1;
    unsigned int encrypt         : 1;
    unsigned int audit           : 1;
} TPMA_SESSION ;
*/
// Table 66 -- TPM2B_AUTH from outputTypeDef <I/O>
//typedef TPM2B_DIGEST    TPM2B_AUTH;

/*
typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  TPMI_RH_PROVISION authHandle;
  TPMI_RH_NV_INDEX nvIndex;
  UINT32 authorizationSize;
//
// NOTE: other input data consists of the following fields.  But it can't be
// specified here because some structures can vary in size.
//
//  TPM2B_NONCE *nonceTpm;
//  TPMA_SESSION sessionAttributes;	//UINT8
//  TPM2B_AUTH *hmac;
//
//  UINT16 size;
//  UINT16 offset;
//
} TPM20_NVRead_In;
*/


/*
typedef struct {
  TPM_ST tag;
  UINT32 responseSize;
  UINT32 responseCode;
//
// NOTE: other output data consists of the following fields.  But it can't be
// specified here because some structures can vary in size.
//
//  TPM2B_MAX_NV_BUFFER data;
//
} TPM20_NVRead_Out;
*/

UINT8 TPM_20_NV_Read( T2P_CMD_SGL *pPackedCmd, UINT8 *indexData, UINT32 dataSize, BOOLEAN verbose)
{
	UINT8 u8CmdStatus = TCG_OK;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT8 *outputBuffer;
	TPM20_NVRead_Index_Out *pOutputStructure;
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;

	//TPM20_NVRead_Index_In inputHeader;
	//TPM2B_NV_PUBLIC *BnvPublic;	// 56 bytes sha1
	
	outputBuffer = AllocateZeroPool(256);
	pOutputStructure = outputBuffer;
	
	/*
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_NVRead_Index_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_NV_Read);
	inputHeader.authHandle = ChangeEndiannessDWord(index);
	inputHeader.nvIndex = ChangeEndiannessDWord(index);
	inputHeader.authorizationSize = ChangeEndiannessDWord(9);
	inputHeader.sessionHandle = ChangeEndiannessDWord(TPM_RS_PW);
	inputHeader.sessionAttributes = 0;
	inputHeader.nonceSize = 0;
	inputHeader.passwordSize = 0;
	inputHeader.size = ChangeEndiannessWord(dataSize);
	inputHeader.offset = ChangeEndiannessWord(0);
	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_NVRead_Index_In);
	DumpHexValue (L"Read Command bytes:", (UINT8 *) &inputHeader, sizeof(TPM20_NVRead_Index_In) );
	*/
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;

	OutputBuffers[0].Buffer = (UINT8 *)outputBuffer;
	OutputBuffers[0].Size = 256;
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
	
		pOutputStructure = outputBuffer;		
		
		if (pOutputStructure->responseCode != TPM_RC_SUCCESS) {	
			Print(L"TPM_20_NV_Read: Return Code  - 0x%x\n",  ChangeEndiannessDWord(pOutputStructure->responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(pOutputStructure->responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		
			outputBuffer += 16;
			CopyMem(indexData, outputBuffer, dataSize);
		
			if(verbose == TRUE){
			
				DumpHexValue (L"Index Data:", (UINT8 *) outputBuffer, dataSize);
			}
		}
		
	}
	
	return u8CmdStatus;
}

/*
typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  UINT32 capability;
  UINT32 property;
  UINT32 propertyCount;
} TPM20_GetCapability_In;
*/

UINT8 TPM_20_Get_Capability(UINT32 capability, UINT32 property, UINT32 propertyCount, BOOLEAN verbose)
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_GetCapability_In inputHeader;
	//UINT8 *outputBuffer;
	TPM20_GetCapability_Out pOutputStructure;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	UINT32	responseSize = 0;
	
	//outputBuffer = AllocateZeroPool(256);
	//pOutputStructure = outputBuffer;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_GetCapability_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_GetCapability);
	inputHeader.capability = ChangeEndiannessDWord(capability);
	inputHeader.property =  ChangeEndiannessDWord(property);
	inputHeader.propertyCount = ChangeEndiannessDWord(propertyCount);
	
	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_GetCapability_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)&pOutputStructure;
	OutputBuffers[0].Size = 256;
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
	
	
		//pOutputStructure = outputBuffer;		
		
		if (pOutputStructure.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(pOutputStructure.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_Get_Capability: Return Code  - 0x%x\n", ChangeEndiannessDWord(pOutputStructure.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(pOutputStructure.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			if(verbose == TRUE){
			
				Print(L"TPM2: TPM_RC_SUCCESS\n");
				responseSize = ChangeEndiannessDWord( pOutputStructure.responseSize );
				Print(L"Response Size: %d\n", responseSize);
				Print(L"More Data: %d\n", pOutputStructure.moreData);
				DumpHexValue (L"Capabilities Data:", (UINT8 *) &pOutputStructure.capabilityData, (responseSize - 14));
			}
		}
		
	} else {
		return -1;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_StartAuthSession(T2P_CMD_SGL *pPackedCmd, UINT32 *authSessionHandle, UINT16 *nonceSize, UINT8 *nonce)
{
	UINT8 u8CmdStatus = TCG_OK;
	//TPM_2_0_StartAuthSession_In inputheader;
	TPM_2_0_StartAuthSession_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	/*
	initStartAuthSession(&inputheader);
	changeEndiannessStartAuthSession(&inputheader);
	
	InputBuffers[0].Buffer = (UINT8 *)&inputheader;
	InputBuffers[0].Size = sizeof(TPM_2_0_StartAuthSession_In);
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_StartAuthSession_Out);
	*/
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_StartAuthSession_Out);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_2_0_StartAuthSession: Return Code  - 0x%08x\n", ChangeEndiannessDWord(outputHeader.responseCode) );
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}
		Print(L"Nonce Size: 0x%04x\n", ChangeEndiannessWord(outputHeader.nonceSize));
		*nonceSize = ChangeEndiannessWord( outputHeader.nonceSize );
		CopyMem(nonce, (UINT8 *)&outputHeader.tpmNonce, *nonceSize );
		DumpHexValue(L"TPM Nonce[20]:", (UINT8 *)&outputHeader.tpmNonce, *nonceSize);
		Print(L"authSessionHandle: 0x%08x\n", outputHeader.authSessionHandle);
		*authSessionHandle = ChangeEndiannessDWord( outputHeader.authSessionHandle );
	}
	else{
		errColor;
		Print(L"ERROR : TPM_2_0_StartAuthSession(), error in executing TPM_2_0_StartAuthSession command\n");
		norColor;
		return TCG_GENERAL_ERROR;
	}
	
	return u8CmdStatus;
}

//replace with send generic command
UINT8 TPM_20_NV_Write( T2P_CMD_SGL *pPackedCmd )
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM_2_0_WRITE_RESPONSE outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_WRITE_RESPONSE);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
		
			Print(L"TPM_20_NV_Write: Return Code  - 0x%08x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}
	}
	else{
	
		errColor;
		Print(L"ERROR : TPM_20_NV_Write(), error in executing TPM_20_NV_Write command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_NV_Delete_Index( T2P_CMD_SGL *pPackedCmd )
{
	UINT8 u8CmdStatus = TCG_OK;
	//TPM_2_0_NV_UNDEF inputHeader;
	TPM_2_0_RET_HEADER outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	//TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	//UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_RET_HEADER);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_NV_Delete_Index: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode) );
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_NV_Delete_Index(), error in executing TPM_20_NV_Delete_Index command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_PolicyLocality(T2P_CMD_SGL *pPackedCmd)
{
	UINT8 u8CmdStatus = TCG_OK;
	//TPM_2_0_PolicyLocality_In inputHeader;
	TPM_2_0_RET_HEADER outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	
	/*
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM_2_0_PolicyLocality_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_PolicyLocality);
	inputHeader.policySession = authSessionHandle;
	inputHeader.locality = 0x18;		// locality 3 & 4
	
	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM_2_0_PolicyLocality_In);
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_RET_HEADER);
	*/
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_RET_HEADER);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_PolicyLocality: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		}
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_PolicyLocality(), error in executing TPM_20_PolicyLocality command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_PolicyGetDigest( T2P_CMD_SGL *pPackedCmd, UINT8 *authPolicyHash, UINT16 *digestSize )
{
	UINT8 u8CmdStatus = TCG_OK;
//	TPM_2_0_CMD_HEADER_POL inputHeader;
	TPM_2_0_PolicyGetDigest_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	//UINT16	digestSize = 0;
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_PolicyGetDigest_Out);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_PolicyGetDigest: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		}
		
		*digestSize = ChangeEndiannessWord( outputHeader.digestSize );
		Print(L"Digest Size: 0x%04x\n", *digestSize );
		DumpHexValue(L"(UINT8 *)&outputHeader.digestData:", (UINT8 *)&outputHeader.digestData, *digestSize);
		CopyMem(authPolicyHash, (UINT8 *)&outputHeader.digestData, *digestSize);
		
		
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_PolicyGetDigest(), error in executing TPM_20_PolicyGetDigest command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_HashSequenceStart( T2P_CMD_SGL *pPackedCmd, UINT32 *hashSeqHandle )
{
	UINT8 u8CmdStatus = TCG_OK;
	//TPM_2_0_CMD_HEADER_POL inputHeader;
	TPM_2_0_HashSequenceStart_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;	
	
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_HashSequenceStart_Out);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_HashSequenceStart: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			*hashSeqHandle = ChangeEndiannessDWord( outputHeader.hashSeqHandle );
			Print(L"hashSeqHandle: 0x%08x\n", *hashSeqHandle );
		}
		
		
				
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_HashSequenceStart(), error in executing TPM_20_HashSequenceStart command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_HashSequenceComplete( T2P_CMD_SGL *pPackedCmd, UINT8 *dataHash, UINT16 *digestSize )
{
	UINT8 u8CmdStatus = TCG_OK;
//	TPM_2_0_CMD_HEADER_POL inputHeader;
	TPM_2_0_HashDigest_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	//UINT16	digestSize = 0;
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_HashDigest_Out);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_HashSequenceComplete: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			//Print(L"Tag: 0x%x\n", ChangeEndiannessWord(outputHeader.tag) );
			//Print(L"Response Size: %d\n", ChangeEndiannessDWord(outputHeader.responseSize) );
			//Print(L"Parameter Area Size: %d\n", ChangeEndiannessDWord(outputHeader.ParameterAreaSize) );

			*digestSize = ChangeEndiannessWord( outputHeader.digestSize );
			//Print(L"Digest Size: 0x%04x\n", *digestSize );
			//DumpHexValue(L"(UINT8 *)&outputHeader.digestData:", (UINT8 *)&outputHeader.digestData, *digestSize);
			CopyMem(dataHash, (UINT8 *)&outputHeader.digestData, *digestSize);
		}
		
		
		
		
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_HashSequenceComplete(), error in executing TPM_20_HashSequenceComplete command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_GetRandom( UINT8 *data, UINT16 *digestSize )
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_GetRandom_In inputHeader;
	TPM20_GetRandom_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_GetRandom_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_GetRandom);
	inputHeader.bytesRequested = ChangeEndiannessWord( *digestSize ); //TPM_SU_CLEAR
	
	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_GetRandom_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM20_GetRandom_Out);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_GetRandom: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			//Print(L"Tag: 0x%x\n", ChangeEndiannessWord(outputHeader.tag) );
			//Print(L"Response Size: %d\n", ChangeEndiannessDWord(outputHeader.responseSize) );
			//Print(L"Parameter Area Size: %d\n", ChangeEndiannessDWord(outputHeader.ParameterAreaSize) );

			*digestSize = ChangeEndiannessWord( outputHeader.dataSize );
			//Print(L"Digest Size: 0x%04x\n", *digestSize );
			//DumpHexValue(L"(UINT8 *)&outputHeader.digestData:", (UINT8 *)&outputHeader.digestData, *digestSize);
			CopyMem(data, (UINT8 *)&outputHeader.otherData, *digestSize);
		}
		
		
		
		
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_GetRandom(), error in executing TPM_20_GetRandom command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_CreatePrimary( T2P_CMD_SGL *pPackedCmd, UINT32 *keyHandle, UINT8 *outPublic, UINT16 *size)
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_CREATE_PRIMARY_OUT outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM20_CREATE_PRIMARY_OUT);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			
			Print(L"TPM2 Command: Return Code  - 0x%08x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			Print(L"Tag: 0x%x\n", ChangeEndiannessWord(outputHeader.tag) );
			Print(L"Response Size: %d\n", ChangeEndiannessDWord(outputHeader.responseSize) );
			Print(L"Primary Key Obj Handle: 0x%x\n", ChangeEndiannessDWord(outputHeader.objectHandle) );
			Print(L"Parameter Area Size: %d\n", ChangeEndiannessDWord(outputHeader.ParameterAreaSize) );
			
			DumpHexValue(L"(UINT8 *)&outputHeader:", (UINT8 *)&outputHeader, ChangeEndiannessDWord(outputHeader.responseSize));

			*keyHandle = ChangeEndiannessDWord(outputHeader.objectHandle);
			*size = ChangeEndiannessWord(outputHeader.outPublic.size) + 2;
			CopyMem(outPublic, (UINT8 *)&outputHeader.outPublic, *size );

			DumpHexValue(L"(UINT8 *)outPublic:", (UINT8 *)outPublic, *size );

		}
	}
	else{
		
		errColor;
		Print(L"ERROR : Error in sending TPM2 command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_LoadExternal( T2P_CMD_SGL *pPackedCmd, UINT32 *objectHandle, UINT8 *objectName, UINT16 *nameSize)
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_LOAD_EXTERNAL_OUT outputHeader;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	
	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM20_LOAD_EXTERNAL_OUT);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			
			Print(L"TPM2 Command: Return Code  - 0x%08x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			Print(L"Tag: 0x%x\n", ChangeEndiannessWord(outputHeader.tag) );
			Print(L"Response Size: %d\n", ChangeEndiannessDWord(outputHeader.responseSize) );
			Print(L"Primary Key Obj Handle: 0x%x\n", ChangeEndiannessDWord(outputHeader.objectHandle) );
			Print(L"Name Size: %d\n", ChangeEndiannessWord(outputHeader.name.size) );
			
			DumpHexValue(L"(UINT8 *)&outputHeader:", (UINT8 *)&outputHeader, ChangeEndiannessDWord(outputHeader.responseSize));

			*objectHandle = ChangeEndiannessDWord(outputHeader.objectHandle);
			*nameSize = ChangeEndiannessWord(outputHeader.name.size) + 2;
			CopyMem(objectName, (UINT8 *)&outputHeader.name, *nameSize );

			DumpHexValue(L"(UINT8 *)outPublic:", (UINT8 *)objectName, *nameSize );

		}
	}
	else{
		
		errColor;
		Print(L"ERROR : Error in sending TPM2 command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_Create( T2P_CMD_SGL *pPackedCmd, UINT8 *outPublic, UINT16 *sizePublic, UINT8 *outPrivate, UINT16 *sizePrivate)
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_CREATE_OUT outputHeader;
	//UINT8	*publicData;
	TIS_BUFFER_INFO InputBuffers[4];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 4;
	UINT32 NumOutputBuffers = 1;
	


	InputBuffers[0].Buffer = (UINT8 *)pPackedCmd->header.address;
	InputBuffers[0].Size = pPackedCmd->header.size;
	InputBuffers[1].Buffer = (UINT8 *)pPackedCmd->handles.address;
	InputBuffers[1].Size = pPackedCmd->handles.size;
	InputBuffers[2].Buffer = (UINT8 *)pPackedCmd->authArea.address;
	InputBuffers[2].Size = pPackedCmd->authArea.size;
	InputBuffers[3].Buffer = (UINT8 *)pPackedCmd->paramBuf.address;
	InputBuffers[3].Size = pPackedCmd->paramBuf.size;
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM20_CREATE_OUT);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS) {
			
			Print(L"TPM2 Command: Return Code  - 0x%08x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
			Print(L"Tag: 0x%x\n", ChangeEndiannessWord(outputHeader.tag) );
			Print(L"Response Size: %d\n", ChangeEndiannessDWord(outputHeader.responseSize) );
			Print(L"Parameter Area Size: %d\n", ChangeEndiannessDWord(outputHeader.ParameterAreaSize) );
			
			DumpHexValue(L"(UINT8 *)&outputHeader:", (UINT8 *)&outputHeader, ChangeEndiannessDWord(outputHeader.responseSize));

			//*sizePrivate = ChangeEndiannessWord(outputHeader.outPrivate.t.size) + 2;
			//CopyMem(outPrivate, (UINT8 *)&outputHeader.outPrivate, *sizePrivate );

			*sizePrivate = ChangeEndiannessWord(*(UINT16*)&outputHeader.paramData[0]) + 2;
			CopyMem(outPrivate, (UINT8 *)&outputHeader.paramData[0], *sizePrivate );
			DumpHexValue(L"(UINT8 *)outPrivate:", (UINT8 *)outPrivate, *sizePrivate );

			
			*sizePublic = ChangeEndiannessWord(*(UINT16*)&outputHeader.paramData[*sizePrivate]) + 2;
			CopyMem(outPublic, (UINT8 *)&outputHeader.paramData[*sizePrivate], *sizePublic );
			DumpHexValue(L"(UINT8 *)outPublic:", (UINT8 *)outPublic, *sizePublic );
			
		}
	}
	else{
		
		errColor;
		Print(L"ERROR : Error in sending TPM2 command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_FlushContext( UINT32 IN authSessionHandle )
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM_2_0_CMD_HEADER_POL inputHeader;
	TPM_2_0_RET_HEADER outputHeader;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM_2_0_CMD_HEADER_POL));
	inputHeader.commandCode = ChangeEndiannessDWord( TPM_CC_FlushContext );
	inputHeader.policySession = ChangeEndiannessDWord( authSessionHandle );
	
	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM_2_0_CMD_HEADER_POL);
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM_2_0_RET_HEADER);
	
	DumpHexValue (L"TPM_20_FlushContext Command bytes:", (UINT8 *) &inputHeader, sizeof(TPM_2_0_CMD_HEADER_POL) );

	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_FlushContext: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}
		
	} else {
		errColor;
		Print(L"ERROR : TPM_20_FlushContext(), error in executing TPM_20_FlushContext command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_Startup( UINT16 startupType )
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_Startup_In inputHeader;
	TPM20_Startup_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_Startup_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_Startup);
	inputHeader.startupType = ChangeEndiannessWord( startupType ); //TPM_SU_CLEAR

	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_Startup_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM20_Startup_Out);
	
	DumpHexValue (L"TPM_20_Startup Command bytes:", (UINT8 *) &inputHeader, sizeof(TPM20_Startup_In) );

	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_Startup: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_Startup(), error in executing TPM_20_Startup command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_Shutdown( UINT16 shutdownType )
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_Shutdown_In inputHeader;
	TPM20_Shutdown_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_Shutdown_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_Shutdown);
	inputHeader.shutdownType = ChangeEndiannessWord( shutdownType ); //TPM_SU_CLEAR

	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_Shutdown_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM20_Shutdown_Out);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_Shutdown: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}

	} else {
		errColor;
		Print(L"ERROR : TPM_20_Shutdown(), error in executing TPM_20_Shutdown command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

UINT8 TPM_20_SelfTest( BOOLEAN selfTestMode ) 
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_Selftest_In inputHeader;
	TPM20_Selftest_Out outputHeader;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_Selftest_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_SelfTest);
	inputHeader.fullTest = selfTestMode; //FULL_SELFTEST or PARTIAL_SELFTEST

	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_Selftest_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)&outputHeader;
	OutputBuffers[0].Size = sizeof(TPM20_Selftest_Out);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		
		if (outputHeader.responseCode != TPM_RC_SUCCESS && ChangeEndiannessDWord(outputHeader.responseCode) != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_SelfTest: Return Code  - 0x%x\n", ChangeEndiannessDWord(outputHeader.responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(outputHeader.responseCode) );
			return TCG_GENERAL_ERROR;
		} else {
			Print(L"TPM2: TPM_RC_SUCCESS\n");
		}
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_SelfTest(), error in executing TPM_20_SelfTest command\n");
		norColor;
	}

	return u8CmdStatus;
}
//typedef UINT16 TPM_ALG_ID;
//#define    TPM_ALG_SHA1                (TPM_ALG_ID)(0x0004) 
/*
// Table 51 -- TPMI_ALG_HASH from outputType <I/O>
typedef TPM_ALG_ID TPMI_ALG_HASH;
*/
/*
// Table 74 -- TPMS_PCR_SELECTION from outputStructDef <I/O>
typedef struct {
    TPMI_ALG_HASH    hash;
    UINT8            sizeofSelect;
    BYTE             pcrSelect[PCR_SELECT_MAX];
} TPMS_PCR_SELECTION;
*/
/*
// Table 91 -- TPML_PCR_SELECTION from outputStructDef <I/O>
typedef struct {
    UINT32                count;
    TPMS_PCR_SELECTION    pcrSelections[HASH_COUNT];
} TPML_PCR_SELECTION;
*/

/*
typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  UINT8 otherData;
//
// NOTE: other input data consists of the following fields.  But it can't be
// specified here because some structures can vary in size.
//
//  TPML_PCR_SELECTION pcrSelection;
//
} TPM20_PcrRead_In;
*/

/*
// Table 63 -- TPM2B_DIGEST from outputStructDef <I/O>
typedef struct {
    UINT16    size;
    BYTE      buffer[sizeof(TPMU_HA)];
} TPM2B_DIGEST;

// Table 88 -- TPML_DIGEST from outputStructDef <I/O>
typedef struct {
    UINT32          count;
    TPM2B_DIGEST    digests[8];
} TPML_DIGEST;
*/
/*
typedef struct {
  TPM_ST tag;
  UINT32 responseSize;
  UINT32 responseCode;
  UINT8 otherData;
//
// NOTE: other output data consists of the following fields.  But it can't be
// specified here because some structures can vary in size.
//
//  UINT32 pcrUpdateCounter
//  TPML_PCR_SELECTION pcrSelectionOut;
//  TPML_DIGEST pcrValues;
//
} TPM20_PcrRead_Out;
*/

//hard coded to write a ps policy for testing

UINT8 TPM_20_ReadPCR( UINT16 tpmAlgId, UINT8 PCRSelect0, UINT8 PCRSelect1, UINT8 PCRSelect2 )
{
	UINT8 u8CmdStatus = TCG_OK;
	TPM20_ReadPcr_In inputHeader;
	TPM20_ReadPcr_Out *pOutputHeader;
	UINT8 *outputBuffer;
	UINT32 i = 0;
	TIS_BUFFER_INFO InputBuffers[1];
	TIS_BUFFER_INFO OutputBuffers[1];
	UINT32 NumInputBuffers = 1;
	UINT32 NumOutputBuffers = 1;
	UINT8 *pPCRsize;
	UINT8 *pTempPCR;
	
	
	outputBuffer = AllocateZeroPool(1024);
	
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_ReadPcr_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_PCR_Read);
	inputHeader.count = ChangeEndiannessDWord(1);
	inputHeader.hashAlg = ChangeEndiannessWord(  tpmAlgId);//
	inputHeader.sizeofSelect = 3; //UINT8
	inputHeader.pcrSelect[0] = PCRSelect0;
	inputHeader.pcrSelect[1] = PCRSelect1;
	inputHeader.pcrSelect[2] = PCRSelect2;

	InputBuffers[0].Buffer = (UINT8 *)&inputHeader;
	InputBuffers[0].Size = sizeof(TPM20_ReadPcr_In);
	
	OutputBuffers[0].Buffer = (UINT8 *)outputBuffer;
	OutputBuffers[0].Size = 1024;//sizeof(outputBuffer);
	
	u8CmdStatus = ExecuteTPMCmdSGL(NumInputBuffers, InputBuffers, NumOutputBuffers, OutputBuffers );
	
	if(TCG_OK == u8CmdStatus){
		pOutputHeader = (TPM20_ReadPcr_Out *)outputBuffer;
		if (pOutputHeader->responseCode != TPM_RC_SUCCESS && pOutputHeader->responseCode != TPM_RC_INITIALIZE) { 
			Print(L"TPM_20_ReadPCR: Return Code  - 0x%x\n", ChangeEndiannessDWord(pOutputHeader->responseCode));
			decodeTpm20ErrorCode( ChangeEndiannessDWord(pOutputHeader->responseCode) );
			return TCG_GENERAL_ERROR;
		}
		
		//printf("pOutputHeader->responseSize: 0x%x\n", ChangeEndiannessDWord(pOutputHeader->responseSize) );
		//DumpHexValue (L"PCR Data:", (UINT8 *) outputBuffer, ChangeEndiannessDWord(pOutputHeader->responseSize) );
		//printf("pOutputHeader->responseCode: 0x%x\n", ChangeEndiannessDWord(pOutputHeader->responseCode) );
		//printf("pOutputHeader->pcrUpdateCounter: 0x%x\n", ChangeEndiannessDWord(pOutputHeader->pcrUpdateCounter) );
		
		Print(L"  PCR Selections Count: 0x%x\n", ChangeEndiannessDWord(pOutputHeader->pcrSelectionsCount) );
		Print(L"  Hash Algorithm:       0x%x\n", ChangeEndiannessWord(pOutputHeader->hashAlg) );
		Print(L"  Size of Select:       0x%x\n", pOutputHeader->sizeofSelect );
		Print(L"  PCR Select[0]:        0x%x\n", pOutputHeader->pcrSelect[0] );
		Print(L"  PCR Select[1]:        0x%x\n", pOutputHeader->pcrSelect[1] );
		Print(L"  PCR Select[2]:        0x%x\n", pOutputHeader->pcrSelect[2] );
		Print(L"  Digest Count:         0x%x\n\n", ChangeEndiannessDWord(pOutputHeader->digestCount) );
		
		pPCRsize = (UINT8*) &(pOutputHeader->digests[0].size);
		pTempPCR = (UINT8*) &(pOutputHeader->digests[0].buffer);
		//pTempPCR = (UINT8*) outputBuffer + 28;
		for ( i = 0; i <  ChangeEndiannessDWord(pOutputHeader->digestCount); i++ ) {
			//printf("pOutputHeader->digestSize %d: 0x%x\n", i, ChangeEndiannessWord(*((UINT16*)pPCRsize) ));
			
			Print(L"TPM PCR %d:", i);
			DumpBinary ((UINT8 *)pTempPCR, ChangeEndiannessWord(*((UINT16*)pPCRsize) ), ChangeEndiannessWord(*((UINT16*)pPCRsize) ), 2, 2);
			pPCRsize = pPCRsize + ChangeEndiannessWord(*((UINT16*)pPCRsize) ) + 2;
			pTempPCR = pTempPCR + ChangeEndiannessWord(*((UINT16*)pPCRsize) ) + 2;
		}		
	}
	else{
		errColor;
		Print(L"ERROR : TPM_20_ReadPCR(), error in executing TPM_20_ReadPCR command\n");
		norColor;
	}
	
	return u8CmdStatus;
}

void displayTPM2info() {

	UINT16 tpmAlgId = 0x0004;
	UINT8 PCRSelect0 = 0xFF;
	UINT8 PCRSelect1 = 0xFF; 
	UINT8 PCRSelect2 = 0xFF;
	
	FSR2B_NV_PUBLIC nvPublic;
	TPM2B_NAME name;
	setActiveLocality0();
	nextStateTransition();
	//remove this for production
	//TPM_20_Startup(); 
	Print(L"************Reading NV Index PS LCP Definition**************\n");
	if ( TCG_GENERAL_ERROR == TPM_20_NV_ReadPublic(0x01800001, 82, &nvPublic, &name, TRUE) ) {
		Print(L"ERROR: PS Policy not present\n\n");
	} else {
		UINT8 indexdata[256];
		TPM_20_NV_Read(0x01800001, indexdata, 54, TRUE);
		Print(L"\n");
	}
	
	//printf("************Reading NV Index PO LCP Definition**************\n");
	Print(L"************Reading NV Index PO LCP Definition**************\n");
	if ( TCG_GENERAL_ERROR == TPM_20_NV_ReadPublic(0x01400001, 82, &nvPublic, &name, TRUE) ){
		Print(L"WARNING : PO Policy not present\n\n");
	} else {
		UINT8 indexdata[256];
		TPM_20_NV_Read(0x01800001, indexdata, 54, TRUE);
		Print(L"\n");
	}
	
	Print(L"************Reading NV Index Aux Definition*****************\n");
	if ( TCG_GENERAL_ERROR == TPM_20_NV_ReadPublic(0x01800003, 82, &nvPublic, &name, TRUE) ){
		Print(L"ERROR: Aux index not present\n\n");
	} else {
		UINT8 indexdata[256];
		TPM_20_NV_Read(0x01800003, indexdata, 96, TRUE);
		Print(L"\n");
	}
	
	Print(L"************Reading TPM Platform Configuration Registers ****\n");
	TPM_20_ReadPCR( tpmAlgId, PCRSelect0, 0, 0 );
	TPM_20_ReadPCR( tpmAlgId, 0, PCRSelect1, 0 );
	TPM_20_ReadPCR( tpmAlgId, 0, 0, PCRSelect2 );
	Print(L"\n");
}
	
void DisplayTPMStatus()
{
	
	TPM *pTPM = (TPM *)TPM_BASE_0; // 0xFED40000
	UINT32 *pTPMStatus = TPM_BASE_0 + 0x18;
	//CpuDeadLoop();
	if (0xFF == pTPM->ACCESS){
		errColor;
		Print(L"ERROR: TPM is not found or is broken. Access register value = 0xFF.\n\n"); 
		norColor;
		return;
	}

	Print(L"TPM Access Register [0xFED4-0000] <value=0x%X>\n", pTPM->ACCESS);
	Print(L"   Bit7  %X     tpmRegValidSts (register valid?)\n", ((pTPM->ACCESS & 0x80) == 0) ? 0 : 1);
	Print(L"   Bit6  %X     Reserved\n", ((pTPM->ACCESS & 0x40) == 0) ? 0 : 1);
	Print(L"   Bit5  %X     activeLocality (active locality?)\n", ((pTPM->ACCESS & 0x20) == 0) ? 0 : 1);
	Print(L"   Bit4  %X     beenSeized     (seized by higher locality?)\n", ((pTPM->ACCESS & 0x10) == 0) ? 0 : 1);
	Print(L"   Bit3  %X     Seize (Write only bit)\n", ((pTPM->ACCESS & 0x8) == 0) ? 0 : 1);
	Print(L"   Bit2  %X     pendingRequest (another locality requesting use?)\n", ((pTPM->ACCESS & 0x4) == 0) ? 0 : 1);
	Print(L"   Bit1  %X     requestUse (This locality is requesting to use TPM?)\n", ((pTPM->ACCESS & 0x2) == 0) ? 0 : 1);
	Print(L"   Bit0  %X     tpmEstablishment (Successful secure launch?)\n", ((pTPM->ACCESS & 0x1) == 0) ? 0 : 1);
	
	Print(L"TPM Status  Register [0xFED4-0018] <value=0x%X>\n", *pTPMStatus);
	Print(L"   23:8  %04x     burstCount (number of bytes that the TPM can read/write)\n", (*pTPMStatus >> 8) & 0x0000FFFF);
	Print(L"   Bit7  %X     stsValid (TPM_STS_x.dataAvail and TPM_STS_x.Expect are valid)\n", ((*pTPMStatus & 0x80) == 0) ? 0 : 1);
	Print(L"   Bit6  %X     commandReady (TPM ready to receive command?)\n", ((*pTPMStatus & 0x40) == 0) ? 0 : 1);
	Print(L"   Bit5  %X     tpmGo (Write only)\n", ((*pTPMStatus & 0x20) == 0) ? 0 : 1);
	Print(L"   Bit4  %X     dataAvail (response data available?)\n", ((*pTPMStatus & 0x10) == 0) ? 0 : 1);
	Print(L"   Bit3  %X     Expect (TPM expects more data for a command?) \n", ((*pTPMStatus & 0x8) == 0) ? 0 : 1);
	Print(L"   Bit2  %X     selfTestDone (TPM completed all self-test actions?)\n", ((*pTPMStatus & 0x4) == 0) ? 0 : 1);
	Print(L"   Bit1  %X     responseRetry (Write only)\n", ((*pTPMStatus & 0x2) == 0) ? 0 : 1);
	Print(L"   Bit0  %X     reserved\n", ((*pTPMStatus & 0x1) == 0) ? 0 : 1);


}

/*****************************End TPM Helper Functions****************************************************/

BOOLEAN verify20TPMPresence()
{
	TPM *pTPM = (TPM *)TPM_BASE_0; // 0xFED40000
	if (0xFF == pTPM->ACCESS){
		errColor;
		//printf("ERROR: TPM is not found or is broken. Access register value = 0xFF.\n\n"); 
		norColor;
		return FALSE;
	} 
	return TRUE;
}

BOOLEAN setActiveLocality0()
{	
	UINT32  *pu32TpmAccess = 0xFED40000;
	*pu32TpmAccess = 0x02;
	return TRUE;
}

BOOLEAN nextStateTransition()
{	
	UINT32  *pu32TpmSts = 0xFED40018;
	*pu32TpmSts = 0x40;
	return TRUE;
}

CHAR16 *mystrtok(CHAR16* string, const CHAR16 *delim)
{
	
    CHAR16 *p;
	CHAR16 *del;
	//CpuDeadLoop();
    if(string != NULL) {
		//Print(L"string not null: %s\n", string);
        ptr = string;
        p = string;
    } else {
		//Print(L"string null: %s\n", string);
        if(*ptr == L'\0') {
            return NULL;
		}
        p = ptr;
    }

    while(*ptr != L'\0') {
        del = delim;
		//Print(L"*del: %s\n", *del);
        while(*del != L'\0') {
			//Print(L"ptr[0]: %s\n", *ptr[0]);
			//Print(L"ptr[0]: %s\n", &ptr[0]);
			//Print(L"del: %s\n", del);
            if(*ptr == *del) {
                if(ptr == p) {
					//Print(L"ptr == p\n");
                    p++;
                    ptr++;
                } else {
                    *ptr = L'\0';
                    ptr++;

                    return p;
                }
            } else {
                del++;
            }
        }
        ptr++;
    }
    return p;
}
